package com.seatel.mobilehall.ui.profile.activity

import android.app.Activity
import android.content.Intent
import android.os.Bundle
import android.view.View
import android.view.animation.AnimationUtils
import com.bumptech.glide.Glide
import com.seatel.mobilehall.R
import com.seatel.mobilehall.databinding.ActivityFingerprintConfirmationBinding
import com.seatel.mobilehall.ui.base.activity.BaseActivity
import com.seatel.mobilehall.ui.login.interactor.FingerprintInteractor
import com.seatel.mobilehall.ui.login.prefs.FingerprintSharePreferences
import com.seatel.mobilehall.ui.login.presenter.FingerprintPresenter
import com.seatel.mobilehall.ui.profile.interactor.CountdownInteractor
import com.seatel.mobilehall.ui.profile.model.CountdownTimerSingletonClass
import com.seatel.mobilehall.util.Constant
import com.seatel.mobilehall.util.SeatelUtils

class FingerprintConfirmationActivity : BaseActivity<ActivityFingerprintConfirmationBinding>(), FingerprintInteractor.View,
    CountdownInteractor {

    private lateinit var fingerprintPresenter: FingerprintPresenter
    private lateinit var countdownTimerSingletonClass: CountdownTimerSingletonClass
    override fun getViewBinding(): ActivityFingerprintConfirmationBinding {
        return ActivityFingerprintConfirmationBinding.inflate(layoutInflater)
    }

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
     //   setContentView(R.layout.activity_fingerprint_confirmation)
        activityEnterFadeInAnimation()

        init()
    }

    private fun init() {
        fingerprintPresenter = FingerprintPresenter(
            this,
            "confirm",
            binding.imgLogoFingerprint,
            SeatelUtils.translatForDialog(this, getString(R.string.fingerprint_not_recognized)),
            this
        )
        countdownTimerSingletonClass = CountdownTimerSingletonClass.getInstance(this)!!
        countdownTimerSingletonClass.setCountdownInteractor(this)
        countdownTimerSingletonClass.initTimer()

        if (countdownTimerSingletonClass.getCountdownTimer() == 0.0) {
            fingerprintPresenter.startListenFingerprint()
            binding.viewTryAgain.visibility = View.GONE
        } else {
            Glide.with(this)
                .load(R.drawable.gif_fingerprint_normal_con)
                .into(binding.imgLogoFingerprint)
        }


    }

    override fun onSuccessAuthenticated() {
        activityExitFadeOutAnimation()
        val intent = Intent()
        intent.putExtra(Constant.FINGERPRINT_RESULT, "true")
        setResult(Activity.RESULT_OK, intent)
        fingerprintPresenter.stopListenFingerprint()
        finish()

    }

    override fun onErrorAuthenticated() {
        FingerprintSharePreferences.getConstant(this).enableFingerprint = false
        doCountdown()
        //stopAnimation()
    }

    private fun doCountdown() {
        countdownTimerSingletonClass.startTimer(31000.0)
    }

    override fun timer(count: Double) {
        binding.viewTryAgain.visibility = View.VISIBLE
        //stopAnimation()
        binding.txtCount.text = "${count.toInt() - 1}"
        if (count == 1.0) {
            binding.viewTryAgain.visibility = View.GONE
            fingerprintPresenter.startListenFingerprint()
        }

    }

    override fun onPause() {
        super.onPause()
        fingerprintPresenter.stopListenFingerprint()
        finish()
    }

    override fun onHideLogoFingerprint() {
        //stopAnimation()
        binding.imgLogoFingerprint.visibility = View.GONE
    }

    private fun stopAnimation() {
        if (binding.imgLogoFingerprint.animation != null) {
            binding.imgLogoFingerprint.animation.cancel()
            binding.imgLogoFingerprint.clearAnimation()
        }
    }

    override fun onShowLogoFingerprint() {
        binding.imgLogoFingerprint.visibility = View.VISIBLE
        //do animation fade in fade out
        //startAnimation()
    }

    private fun startAnimation() {
        binding.imgLogoFingerprint.startAnimation(
            AnimationUtils.loadAnimation(
                this,
                R.anim.fingerprint_fade_in_fade_out_logo
            )
        )
    }


    override fun isDisplayToolbar(): Boolean {
        return true
    }

    override fun isCancelBackType(): Boolean {
        return true
    }

    override fun getStringToolbarTitle(): String? {
        return getString(R.string.fingerprint_id)
    }

    override fun onBackPressed() {
        super.onBackPressed()
        onHideLogoFingerprint()
        activityExitFadeOutAnimation()
    }


}
