package com.seatel.mobilehall.util.customview.adapter

import android.view.LayoutInflater
import android.view.ViewGroup
import androidx.recyclerview.widget.RecyclerView
import com.seatel.mobilehall.databinding.HolderDialogChooseItemBinding
import com.seatel.mobilehall.util.customview.BottomChooserDialog

class BottomChooserAdapter : RecyclerView.Adapter<BottomChooserAdapter.BottomChooserViewHolder>() {
    private var bottomChooserModels = ArrayList<BottomChooserDialog.BottomChooserModel>()
    private var onItemClick: OnItemClick? = null

    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): BottomChooserViewHolder {
        // Use ViewBinding to inflate the view
        val binding = HolderDialogChooseItemBinding.inflate(LayoutInflater.from(parent.context), parent, false)
        return BottomChooserViewHolder(binding)
    }

    override fun getItemCount(): Int {
        return bottomChooserModels.size
    }

    override fun onBindViewHolder(holder: BottomChooserViewHolder, position: Int) {
        // Use ViewBinding to access the views
        holder.binding.tvChooser.text = bottomChooserModels[position].name
        holder.itemView.setOnClickListener {
            onItemClick?.onClick(position, bottomChooserModels[position])
        }
    }

    interface OnItemClick {
        fun onClick(position: Int, data: BottomChooserDialog.BottomChooserModel)
    }

    fun addItems(bottomChooserModels: ArrayList<BottomChooserDialog.BottomChooserModel>, onItemClick: OnItemClick) {
        this.onItemClick = onItemClick
        this.bottomChooserModels.clear()
        this.bottomChooserModels.addAll(bottomChooserModels)
    }

    class BottomChooserViewHolder(val binding: HolderDialogChooseItemBinding) : RecyclerView.ViewHolder(binding.root)
}
