package com.seatel.mobilehall.ui.home.adapter

import android.content.Context
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.view.animation.AnimationUtils
import android.widget.ImageView
import android.widget.TextView
import androidx.recyclerview.widget.RecyclerView
import com.bumptech.glide.Glide
import com.seatel.mobilehall.R
import com.seatel.mobilehall.ui.base.adapter.BaseAdapter
import com.seatel.mobilehall.ui.home.model.CategoryModel

class CategoryAdapter(
    private val mContext: Context,
    private var mCategoryModel: ArrayList<CategoryModel>,
    private var rowClick: (index: CategoryModel) -> Unit
) : BaseAdapter<CategoryAdapter.CategoryViewHolder>() {


    override fun onCreateViewHolder(
        parent: ViewGroup,
        viewType: Int
    ): CategoryViewHolder {
        return CategoryViewHolder(
            LayoutInflater.from(mContext).inflate(R.layout.item_category, parent, false)
        )
    }

    override fun onBindViewHolder(holder: CategoryViewHolder, position: Int) {
        holder.itemView.visibility = View.INVISIBLE
        setMyAnimation(
            holder.itemView,
            position,
            AnimationUtils.loadAnimation(
                holder.itemView.context,
                R.anim.anim_recycler_item_horizontal
            )
        )
        val data = mCategoryModel[position]
        Glide.with(mContext).load(mCategoryModel[position].icon).into(holder.mIcon)
        holder.mTitle.text = mCategoryModel[position].name

        if (mCategoryModel[position].name == "Hit The Pots") {
            if (mCategoryModel[position].chance!! > 0){
                holder.chanceBadge.visibility = View.VISIBLE
                holder.chanceBadge.text = mCategoryModel[position].chance.toString()
            }


        }

        holder.itemView.setOnClickListener {
            data.let(rowClick)
        }
    }

    override fun getItemCount(): Int {
        return mCategoryModel.size
    }


    class CategoryViewHolder(itemView: View) : RecyclerView.ViewHolder(itemView) {
        val mIcon = itemView.findViewById<ImageView>(R.id.ivIcon)
        val mTitle = itemView.findViewById<TextView>(R.id.tvTitle)
        val chanceBadge = itemView.findViewById<TextView>(R.id.count_badge_chance)
    }

}