package com.seatel.mobilehall.util

import android.app.Activity
import android.content.Context
import android.content.DialogInterface

import androidx.appcompat.app.AlertDialog
import com.seatel.mobilehall.R
import com.seatel.mobilehall.util.SeatelUtils.Companion.translatForDialog

class SeatelAlertDialog(private val mContext: Context, message: String?) {
    private val alertDialogBuilder: AlertDialog.Builder
    var cancelable = false
        private set
    private var positiveButton: String
    private var negativeButton: String? = null
    private var positiveClickListener: DialogInterface.OnClickListener? = null
    private var negativeClickListener: DialogInterface.OnClickListener? = null
    private var dismissListener: DialogInterface.OnDismissListener? = null
    private var alertDialog: AlertDialog? = null
    fun dimissDialog() {
        if (alertDialog != null) alertDialog!!.dismiss()
    }

    fun show(): SeatelAlertDialog {
        alertDialogBuilder.setCancelable(cancelable)
        //        alertDialogBuilder.setPositiveButton(LanguageManager.translateWords(mContext, positiveButton), positiveClickListener);
        alertDialogBuilder.setPositiveButton(positiveButton, positiveClickListener)
        if (negativeClickListener != null) alertDialogBuilder.setNegativeButton(
            negativeButton,
            negativeClickListener
        )
        //        alertDialogBuilder.setNegativeButton(LanguageManager.translateWords(mContext, negativeButton), negativeClickListener);
        if (dismissListener != null) alertDialogBuilder.setOnDismissListener(dismissListener)
        alertDialog = alertDialogBuilder.create()
        if (!(mContext as Activity).isDestroyed && alertDialog != null && !alertDialog!!.isShowing) alertDialog!!.show()
        return this
    }

    fun setPositiveButton(
        text: String?,
        clickListener: DialogInterface.OnClickListener?
    ): SeatelAlertDialog {
        positiveButton = translatForDialog(mContext, text)
        positiveClickListener = clickListener
        return this
    }

    fun setNegativeButton(
        text: String?,
        clickListener: DialogInterface.OnClickListener?
    ): SeatelAlertDialog {
        negativeButton = translatForDialog(mContext, text)
        negativeClickListener = clickListener
        return this
    }

    fun setDismiss(dismissListener: DialogInterface.OnDismissListener?): SeatelAlertDialog {
        this.dismissListener = dismissListener
        return this
    }

    fun setCancelable(cancelable: Boolean): SeatelAlertDialog {
        this.cancelable = cancelable
        return this
    }

    companion object {
        fun with(context: Context, message: String?): SeatelAlertDialog {
            return SeatelAlertDialog(context, translatForDialog(context, message))
        }
    }

    init {
        positiveButton = translatForDialog(mContext, mContext.getString(R.string.yes))
        alertDialogBuilder = AlertDialog.Builder(mContext)
        //        alertDialogBuilder.setMessage(LanguageManager.translateWords(context, message));
        alertDialogBuilder.setMessage(translatForDialog(mContext, message))
    }
}