package com.seatel.mobilehall.data.network

import android.content.Context
import com.google.gson.Gson
import com.seatel.mobilehall.data.prefs.LanguagePreference
import com.seatel.mobilehall.ui.lang.model.LanguageModel
import com.seatel.mobilehall.util.Constant
import com.seatel.mobilehall.util.lang.LanguageManager
import org.json.JSONObject

class GetLanguage(context: Context?) : SeatelJSONObjectRequest(context) {

    override fun getFunctionName(): String {
        return Constant.ALL_LANGUAGE
    }


    override fun onResponse(response: JSONObject?) {
        super.onResponse(response)

        val version = response?.optString("version", "0.1")

        LanguagePreference.getInstance(context)?.setLanguageVersion(version)
        LanguageManager.getInstance(context).clearAll()
        LanguageManager.getInstance(context).updateLanguage(response)


        val languageModels = ArrayList<LanguageModel>()
        languageModels.add(LanguageModel(1, "ភាសាខ្មែរ", "km"))
        languageModels.add(LanguageModel(2, "English", "en"))
        languageModels.add(LanguageModel(3, "中文", "zh"))
        LanguagePreference.getInstance(context)
            ?.setAppSharedLanguagePreference(Gson().toJson(languageModels))
    }

}