package com.seatel.mobilehall.ui.home.adapter

import android.content.Context
import android.view.LayoutInflater
import android.view.ViewGroup
import androidx.recyclerview.widget.RecyclerView
import com.seatel.mobilehall.R
import com.seatel.mobilehall.databinding.SupportListItemBinding
import com.seatel.mobilehall.ui.base.adapter.BaseAdapter
import com.seatel.mobilehall.ui.home.interactor.ItemViewInteractor
import com.seatel.mobilehall.ui.home.model.SupportedDeviceModel

class SupportListAdapter(
    private val context: Context,
    private val supportedDeviceList: List<SupportedDeviceModel>,
    private val onClickItem: ItemViewInteractor
) : BaseAdapter<SupportListAdapter.SupportListVH>() {

    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): SupportListVH {
        // Inflate the layout using ViewBinding
        val binding = SupportListItemBinding.inflate(LayoutInflater.from(context), parent, false)
        return SupportListVH(binding)
    }

    override fun getItemCount(): Int = supportedDeviceList.size

    override fun onBindViewHolder(holder: SupportListVH, position: Int) {
        holder.bind(supportedDeviceList[position], position)
    }

    inner class SupportListVH(private val binding: SupportListItemBinding) : RecyclerView.ViewHolder(binding.root) {

        fun bind(supportedDevice: SupportedDeviceModel, position: Int) {
            // Set text for the description
            binding.textDescription.text = supportedDevice.brand

            // Handle item click
            itemView.setOnClickListener {
                onClickItem.onClick(it, position)
            }
        }
    }
}
