package com.seatel.mobilehall.util.dialogannouncement

import android.app.Dialog
import android.content.Context
import android.content.DialogInterface
import android.graphics.Color
import android.graphics.drawable.ColorDrawable
import android.view.View
import android.view.ViewGroup
import android.view.Window
import android.widget.Button
import android.widget.TextView
import com.seatel.mobilehall.R
import com.seatel.mobilehall.util.SeatelUtils.Companion.translatForDialog

class RedeemCustomDialog(
    context: Context,
    title: String,
    subtitle: String = "",
    positiveButtonText: String = ""
) : Dialog(context) {

    private var positiveClickListener: DialogInterface.OnClickListener? = null

    init {
        initValentine(title, subtitle, positiveButtonText)
    }

    private fun initValentine(
        title: String,
        subtitle: String,
        positiveButtonText: String
    ) {
        requestWindowFeature(Window.FEATURE_NO_TITLE)
        setContentView(R.layout.dialog_redeem)
        setCancelable(false)
        window?.apply {
            setLayout(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.MATCH_PARENT)
            attributes.windowAnimations = R.style.DialogAnimationScaleInOut
            setDimAmount(0.5f)
            setBackgroundDrawable(ColorDrawable(Color.TRANSPARENT))
        }

        val mTitle = findViewById<TextView>(R.id.tv_title)
        val mDescription = findViewById<TextView>(R.id.tv_description)
        val mBtnPositive = findViewById<Button>(R.id.btn_done)

        mTitle?.text = translatForDialog(context, title)
        mDescription?.text = translatForDialog(context, subtitle)



        mBtnPositive?.apply {
            text = translatForDialog(context, positiveButtonText)
            visibility = if (positiveButtonText.isNotEmpty()) View.VISIBLE else View.GONE
            setOnClickListener {
                positiveClickListener?.onClick(
                    this@RedeemCustomDialog,
                    DialogInterface.BUTTON_POSITIVE
                )
            }
        }

    }

    fun setPositiveButton(
        text: String,
        clickListener: DialogInterface.OnClickListener
    ): RedeemCustomDialog {
        val mBtnPositive = findViewById<Button>(R.id.btn_positive)
        mBtnPositive?.text = translatForDialog(context, text)
        mBtnPositive?.visibility = View.VISIBLE
        positiveClickListener = clickListener
        return this
    }

}
