package com.seatel.mobilehall.ui.yes_member.presenter

import android.content.Context
import com.android.volley.Request
import com.google.gson.Gson
import com.google.gson.reflect.TypeToken
import com.seatel.mobilehall.data.network.SeatelJSONArrayRequest
import com.seatel.mobilehall.ui.yes_member.interactor.TopPartnerInteractor
import com.seatel.mobilehall.ui.yes_member.model.PartnerModelItem
import org.json.JSONArray

class TopPartnerPresenter(
    private var mContext: Context, private var topPartnerInteractor: TopPartnerInteractor.View
) : TopPartnerInteractor.Presenter {


    override fun onTopPartner() {
        topPartnerRequest().setOnErrorListener { error ->
            topPartnerInteractor.responseTopPartnerFail(error)
        }.setOnResponseListener { response ->
            topPartnerInteractor.responseTopPartnerSucceed(getTopPartnerList(response as JSONArray))
        }.execute()
    }


    private fun getTopPartnerList(response: JSONArray): ArrayList<PartnerModelItem> {
        val gson = Gson()
        val responseString = response.toString()
        val listType = object : TypeToken<ArrayList<PartnerModelItem>>() {}.type
        return gson.fromJson(responseString, listType)
    }

    private fun topPartnerRequest(): SeatelJSONArrayRequest {
        return object : SeatelJSONArrayRequest(mContext) {
            override fun getFunctionName(): String {
                return "yes-member/top-partner"
            }

            override fun getMethod(): Int {
                return Request.Method.GET
            }

        }
    }


}