package com.seatel.mobilehall.ui.yes_member.adapter

import android.content.Context
import android.view.ViewGroup
import androidx.recyclerview.widget.RecyclerView
import com.seatel.mobilehall.databinding.ItemEarnCoinBinding
import com.seatel.mobilehall.ui.yes_member.model.EarnCoinModel

class EarnCoinAdapter(var mContext: Context, var earnCoinList: ArrayList<EarnCoinModel>) :
    RecyclerView.Adapter<EarnCoinAdapter.ViewHolder>() {


    class ViewHolder(var binding: ItemEarnCoinBinding) : RecyclerView.ViewHolder(binding.root) {
        fun bind(earnCoinModel: EarnCoinModel) {

            binding.tvPlanService.text = earnCoinModel.planService
            binding.tvCoin.text = earnCoinModel.coinDesc
        }
    }


    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): EarnCoinAdapter.ViewHolder {
        val binding = ItemEarnCoinBinding.inflate(
            android.view.LayoutInflater.from(parent.context), parent, false
        )
        return ViewHolder(binding)

    }

    override fun onBindViewHolder(holder: EarnCoinAdapter.ViewHolder, position: Int) {
        holder.bind(earnCoinList[position])
    }

    override fun getItemCount(): Int {
        return earnCoinList.size
    }

}