package com.seatel.mobilehall.ui.yes_member.activity

import android.content.Context
import android.content.Intent
import android.os.Bundle
import android.view.KeyEvent
import android.view.inputmethod.EditorInfo
import android.widget.EditText
import androidx.recyclerview.widget.GridLayoutManager
import com.android.volley.VolleyError
import com.seatel.mobilehall.data.network.SeatelSuperRequest
import com.seatel.mobilehall.databinding.ActivityPartnerSearchBinding
import com.seatel.mobilehall.ui.base.activity.BaseActivity
import com.seatel.mobilehall.ui.yes_member.adapter.MainPartnerCategoryAdapter
import com.seatel.mobilehall.ui.yes_member.adapter.PartnerSearchCategoryListAdapter
import com.seatel.mobilehall.ui.yes_member.adapter.TopPartnerSearchAdapter
import com.seatel.mobilehall.ui.yes_member.interactor.PartnerSearchInteractor
import com.seatel.mobilehall.ui.yes_member.model.PartnerCategoryModelItem
import com.seatel.mobilehall.ui.yes_member.model.PartnerModelItem
import com.seatel.mobilehall.ui.yes_member.model.PartnerSearchCategoryModel
import com.seatel.mobilehall.ui.yes_member.presenter.PartnerSearchPresenter
import com.seatel.mobilehall.util.SeatelAlertDialog

class PartnerSearchActivity : BaseActivity<ActivityPartnerSearchBinding>(),
    PartnerSearchInteractor.View {


    companion object {
        fun launch(context: Context) {
            val intent = Intent(context, PartnerSearchActivity::class.java)
            context.startActivity(intent)
        }

    }

    private lateinit var originalList: ArrayList<PartnerModelItem>
    private lateinit var adapter: TopPartnerSearchAdapter


    override fun getViewBinding(): ActivityPartnerSearchBinding {
        return ActivityPartnerSearchBinding.inflate(layoutInflater)
    }

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        super.activityEnterRightAnimation()
        binding.ivBack.setOnClickListener {
            onBackPressed()
        }
        binding.tvCancel.setOnClickListener {
            binding.btnSearch.text?.clear()
        }
        PartnerSearchPresenter(this, this).onTopPartner()
        PartnerSearchPresenter(this, this).onPartnerCategory()

        setupSearch(binding.btnSearch)
    }

    private fun setupSearch(searchEditText: EditText) {
        searchEditText.setOnEditorActionListener { _, actionId, event ->
            if (actionId == EditorInfo.IME_ACTION_SEARCH ||
                (event != null && event.keyCode == KeyEvent.KEYCODE_ENTER && event.action == KeyEvent.ACTION_DOWN)
            ) {

                filterList(searchEditText.text.toString())
                return@setOnEditorActionListener true
            }
            false
        }
    }

    private fun filterList(query: String) {
        val filteredList = originalList.filter {
            it.name.contains(
                query,
                ignoreCase = true
            ) // Assuming PartnerSearchCategoryModel has a `name` field
        }
        adapter.updateList(ArrayList(filteredList)) // Update the adapter with the filtered data
    }


    override fun isDisplayToolbar(): Boolean {
        return false
    }

    override fun onBackPressed() {
        super.onBackPressed()
        super.activityExitLeftAnimation()
    }

    override fun onTopPartnerSucceed(partnerSearchList: ArrayList<PartnerModelItem>) {
        originalList = partnerSearchList
        adapter = TopPartnerSearchAdapter(this, originalList)
        binding.recyclerPartner.adapter = adapter
    }

    override fun onTopPartnerFail(error: VolleyError) {
        SeatelAlertDialog.with(this, SeatelSuperRequest.getErrorMessageFrom(error))
            .show()
    }

    override fun responsePartnerCategorySucceed(partnerCategory: ArrayList<PartnerCategoryModelItem>) {
        binding.recyclerCategoryPartner.layoutManager = GridLayoutManager(this, 2)
        binding.recyclerCategoryPartner.adapter = MainPartnerCategoryAdapter(this, partnerCategory)
    }

    override fun responsePartnerCategoryFail(error: VolleyError) {
        SeatelAlertDialog.with(this, SeatelSuperRequest.getErrorMessageFrom(error))
            .show()
    }


}