package com.seatel.mobilehall.ui.yes_member.activity

import android.content.Context
import android.content.Intent
import android.os.Bundle
import android.util.Log
import com.android.volley.VolleyError
import com.seatel.mobilehall.data.network.SeatelSuperRequest
import com.seatel.mobilehall.databinding.ActivityEarnCoinBinding
import com.seatel.mobilehall.ui.base.activity.BaseActivity
import com.seatel.mobilehall.ui.yes_member.adapter.EarnCoinAdapter
import com.seatel.mobilehall.ui.yes_member.interactor.EarnCoinInteractor
import com.seatel.mobilehall.ui.yes_member.model.EarnCoinModel
import com.seatel.mobilehall.ui.yes_member.presenter.EarnCoinPresenter
import com.seatel.mobilehall.util.SeatelAlertDialog

class EarnCoinActivity : BaseActivity<ActivityEarnCoinBinding>(), EarnCoinInteractor.View {


    companion object {
        fun launch(context: Context) {
            val intent = Intent(context, EarnCoinActivity::class.java)
            context.startActivity(intent)
        }
    }

    override fun getViewBinding(): ActivityEarnCoinBinding {
        return ActivityEarnCoinBinding.inflate(layoutInflater)
    }


    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        activityEnterRightAnimation()
        EarnCoinPresenter(this, this).getEarnCoins()
    }


    override fun getStringToolbarTitle(): String? {
        return "How to Earn yesCoins"
    }

    override fun responseEarnCoinSucceed(earnCoinList: ArrayList<EarnCoinModel>) {
        val adapter = EarnCoinAdapter(this, earnCoinList)
        binding.recyclerEarnCoin.adapter = adapter
    }

    override fun responseEarnCoinFail(error: VolleyError) {
        SeatelAlertDialog.with(this, SeatelSuperRequest.getErrorMessageFrom(error))
            .show()
    }

    override fun onBackPressed() {
        super.onBackPressed()
        super.activityExitLeftAnimation()
    }

}