package com.seatel.mobilehall.ui.splashscreen

import android.os.Bundle
import android.os.Handler
import android.os.Looper
import androidx.appcompat.app.AppCompatActivity
import com.google.gson.Gson
import com.seatel.mobilehall.R
import com.seatel.mobilehall.data.network.GetLanguage
import com.seatel.mobilehall.data.prefs.LanguagePreference
import com.seatel.mobilehall.ui.lang.model.LanguageModel
import com.seatel.mobilehall.ui.main.MainActivity
import com.seatel.mobilehall.ui.profile.activity.SettingLanguageActivity
import com.seatel.mobilehall.util.lang.FirstLoginPreference

class SplashScreenActivity : AppCompatActivity() {


    private var handler: Handler? = null
    private var loginSuccess: String? = null
    private var isFirstInstall: Boolean = false

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.activity_splash_screen)
        getLanguageData()
        initSplashScreen()
    }


    private fun initSplashScreen() {
        //  loginSuccess = SeatelSharePreferences(this).getLoginSuccess()
        FirstLoginPreference.getInstance(this)?.setIsForceUpdatePreference(false)
        isFirstInstall = FirstLoginPreference.getInstance(this)?.isFirstInstall()!!
        handler = Handler(Looper.getMainLooper())
        if (handler != null) {
            handler!!.postDelayed({
                /* if (TextUtils.equals(loginSuccess, "")) {
                     LoginActivity.lunch(applicationContext)
                 } else {
                     MainActivity.lunch(this)
                 }*/
                if (!isFirstInstall) {
                    SettingLanguageActivity.launch(this)
                } else
                    MainActivity.lunch(this)
                handler!!.removeCallbacksAndMessages(this)
                handler = null
                finish()
            }, 2000)
        }
    }

    private fun getLanguageData() {
        val languageModels = ArrayList<LanguageModel>()
        languageModels.add(LanguageModel(1, "ភាសាខ្មែរ", "km"))
        languageModels.add(LanguageModel(2, "English", "en"))
        languageModels.add(LanguageModel(3, "中文", "zh"))
        LanguagePreference.getInstance(applicationContext)
            ?.setAppSharedLanguagePreference(Gson().toJson(languageModels))

        GetLanguage(applicationContext).execute()
    }

}