package com.seatel.mobilehall.ui.login.presenter

import android.content.Context
import com.android.volley.Request
import com.seatel.mobilehall.data.network.SeatelJSONObjectRequest
import com.seatel.mobilehall.ui.login.interactor.ForgotPasswrodVerifyCodeInteractor
import com.seatel.mobilehall.util.Constant
import org.json.JSONException
import org.json.JSONObject

class ForgotPasswrodVerifyCodePresenter(
    private var mContext: Context,
    private var mSingUpView: ForgotPasswrodVerifyCodeInteractor.View? = null
) : ForgotPasswrodVerifyCodeInteractor.Presenter {

    private var requestForgot: SeatelJSONObjectRequest? = null
    override fun onVerifyCode(codeConfirm: String, phoneNumber: String) {
        postVerifyCodeRequest(codeConfirm, phoneNumber).setOnErrorListener { error ->
            mSingUpView?.onVerifyCodeFailed(error)
        }.setOnResponseListener { response ->
            mSingUpView?.onVerifyCodeSucceed()
        }.execute()
    }

    fun onDestroy() {
        mSingUpView = null
    }

    private fun postVerifyCodeRequest(
        codeConfirm: String,
        phoneNumber: String
    ): SeatelJSONObjectRequest {


        requestForgot = object : SeatelJSONObjectRequest(mContext) {

            override fun onGetBodyRequest(): String {
                val data = JSONObject()
                try {
                    data.put("code", codeConfirm)
                    data.put("phoneNumber", phoneNumber)
                } catch (e: JSONException) {
                    e.printStackTrace()
                }

                return data.toString()
            }

            override fun getFunctionName(): String {
                return Constant.VERIFY_CODE
            }

            override fun getMethod(): Int {
                return Request.Method.POST
            }

        }
        return requestForgot!!
    }
}