package com.seatel.mobilehall.ui.login.presenter

import android.content.Context
import android.text.TextUtils
import com.android.volley.Request
import com.seatel.mobilehall.data.network.SeatelJSONObjectRequest
import com.seatel.mobilehall.data.prefs.SeatelSharePreferences
import com.seatel.mobilehall.ui.login.interactor.ConfirmSignUpInteractor
import com.seatel.mobilehall.util.Constant
import org.json.JSONException
import org.json.JSONObject

class ConfirmSignUpPresenter(
    private var mContext: Context,
    private var mSingUpView: ConfirmSignUpInteractor.View? = null
) : ConfirmSignUpInteractor.Presenter {
    private var requestConfirm: SeatelJSONObjectRequest? = null
    override fun onConfirmCode(
        version: String,
        codeConfirm: String,
        email: String,
        mainPhoneNumber: String,
        phoneNumber: String,
        password: String,
        socialType: String,
        action: String
    ) {
        postSignUpRequest(
            version,
            codeConfirm,
            email,
            mainPhoneNumber,
            phoneNumber,
            password,
            socialType,
            action
        ).setOnErrorListener { error ->
            mSingUpView?.onConfirmFailed(error)
        }.setOnResponseListener { _ ->
            mSingUpView?.onConfirmSucceed()
        }.execute()
    }

    fun onDestroy() {
        mSingUpView = null
    }

    private fun postSignUpRequest(
        version: String,
        codeConfirm: String,
        email: String,
        mainPhoneNumber: String,
        phoneNumber: String,
        password: String,
        socialType: String,
        action: String
    ): SeatelJSONObjectRequest {
        SeatelSharePreferences.getInstance(mContext)!!.setPasswordLogin(password)
        requestConfirm?.cancel()
        requestConfirm = object : SeatelJSONObjectRequest(mContext) {

            override fun onGetBodyRequest(): String {
                val data = JSONObject()
                try {
                    data.put("code", codeConfirm)
                    data.put("phoneNumber", phoneNumber)
                    if (mainPhoneNumber.isNotEmpty())
                        data.put("newPhoneNumber", mainPhoneNumber)
                    if (TextUtils.equals(action, Constant.REGISTER)) {
                        data.put("email", email)
                    } else if (TextUtils.equals(action, Constant.SOCIAL_REGISTER)) {
                        data.put("socialId", email)
                        data.put("socialType", socialType)
                    }
                    if (!TextUtils.isEmpty(password))
                        data.put("password", password)
                    data.put("action", action)
                } catch (e: JSONException) {
                    e.printStackTrace()
                }

                return data.toString()
            }

            override fun getFunctionName(): String {
                if (version.isEmpty())
                    return Constant.USER_CONFIRM_CODE
                return version + Constant.USER_CONFIRM_CODE
            }

            override fun getMethod(): Int {
                return Request.Method.POST
            }

        }
        return requestConfirm!!
    }
}