package com.seatel.mobilehall.ui.home.adapter

import android.content.Context
import android.view.LayoutInflater
import android.view.ViewGroup
import androidx.recyclerview.widget.RecyclerView
import com.seatel.mobilehall.R
import com.seatel.mobilehall.databinding.SupportedDeviceDetailItemBinding
import com.seatel.mobilehall.ui.base.adapter.BaseAdapter

class SupportedDeviceDetailAdapter(
    private val context: Context,
    private val supportedDeviceDetailList: List<String>
) : BaseAdapter<SupportedDeviceDetailAdapter.SupportListVH>() {

    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): SupportListVH {
        // Inflate the layout using ViewBinding
        val binding = SupportedDeviceDetailItemBinding.inflate(LayoutInflater.from(context), parent, false)
        return SupportListVH(binding)
    }

    override fun getItemCount(): Int = supportedDeviceDetailList.size

    override fun onBindViewHolder(holder: SupportListVH, position: Int) {
        holder.bind(supportedDeviceDetailList[position])
    }

    inner class SupportListVH(private val binding: SupportedDeviceDetailItemBinding) : RecyclerView.ViewHolder(binding.root) {

        fun bind(description: String) {
            // Set text for the description
            binding.textDescription.text = description
        }
    }
}
