package com.seatel.mobilehall.ui.home.adapter;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.content.ContextCompat;
import androidx.swiperefreshlayout.widget.CircularProgressDrawable;
import androidx.viewpager.widget.PagerAdapter;

import com.bumptech.glide.Glide;
import com.bumptech.glide.load.DataSource;
import com.bumptech.glide.load.engine.GlideException;
import com.bumptech.glide.request.RequestListener;
import com.bumptech.glide.request.target.Target;
import com.seatel.mobilehall.R;
import com.seatel.mobilehall.ui.home.interactor.PromotionsInteractor;
import com.seatel.mobilehall.util.customview.ImageViewFitYCropX;

import java.util.ArrayList;
import java.util.List;

public class PromotionAdapter extends PagerAdapter {

    private List<String> viewList;
    private final Context mConText;
    private PromotionsInteractor.View itemClick;

    public PromotionAdapter(Context context) {
        this.mConText = context;
        this.viewList = new ArrayList<>();
    }

    public void setItemClick(PromotionsInteractor.View itemClick) {
        this.itemClick = itemClick;
    }

    @NonNull
    @Override
    public Object instantiateItem(@NonNull ViewGroup container, int position) {

        int modelPosition = mapPagerPositionToModelPosition(position);
        ImageView view = createPageView(viewList.get(modelPosition), modelPosition);
        if (view.getParent() != null) {
            container.removeView(view);
        }
        container.addView(view);
        return view;

//        if (viewList != null && viewList.size() > 0) {
//            position = position % viewList.size();
//            ImageView view = viewList.get(position);
//            if (view.getParent() != null) {
//                container.removeView(view);
//            }
//            Log.d("position", "view==" + view.getTag());
//            container.addView(view);
//            return view;
//        } else {
//            ImageView view = viewList.get(position);
//            container.addView(view);
//            return view;
//        }

    }

    private ImageView createPageView(String urlImage, int index) {
        ImageView view = new ImageViewFitYCropX(mConText);
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(RelativeLayout.LayoutParams.MATCH_PARENT, RelativeLayout.LayoutParams.MATCH_PARENT);
        params.addRule(RelativeLayout.ALIGN_PARENT_TOP);
        view.setAdjustViewBounds(true);
        view.setLayoutParams(params);
        view.setScaleType(ImageView.ScaleType.FIT_CENTER);
        final CircularProgressDrawable loadingImage = new CircularProgressDrawable(mConText);
        loadingImage.setStrokeWidth(5f);
        loadingImage.setCenterRadius(30f);
        loadingImage.setColorSchemeColors(ContextCompat.getColor(mConText, R.color.colorPrimary));
        loadingImage.start();
        Glide.with(mConText).load(urlImage)
                .placeholder(loadingImage)
                .fitCenter()
                .listener(new RequestListener<Drawable>() {
                    @Override
                    public boolean onLoadFailed(@Nullable GlideException e, Object model, Target<Drawable> target, boolean isFirstResource) {
                        loadingImage.setVisible(false, false);
                        return false;
                    }

                    @Override
                    public boolean onResourceReady(Drawable resource, Object model, Target<Drawable> target, DataSource dataSource, boolean isFirstResource) {
                        return false;
                    }
                }).into(view);
        view.setTag(index);
        view.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if (v.getTag() != null) {
                    itemClick.onItemClick(v.getTag().toString());
                }

//                showDetailScreen((v.getTag()).toString());
            }
        });
        return view;
    }

    private int mapPagerPositionToModelPosition(int pagerPosition) {
        // Put last page model to the first position.
        if (pagerPosition == 0) {
            return 0;
        }
        // Put first page model to the last position.
        if (pagerPosition == getRealCount() + 1) {
            return 0;
        }
        return pagerPosition - 1;
    }

    @Override
    public void destroyItem(@NonNull ViewGroup container, int position, @NonNull Object object) {
//        container.removeView((View) object);
    }

    @Override
    public int getCount() {
        return viewList.size() == 0 ? 0 : viewList.size() + 2;
    }

    public int getRealCount() {
        return viewList.size();
    }

    @Override
    public boolean isViewFromObject(@NonNull View view, @NonNull Object object) {
        return view == object;
    }

    @Override
    public int getItemPosition(@NonNull Object object) {
        return POSITION_NONE;
    }

    public void setData(List<String> list) {
        this.viewList.clear();
        if (list != null && !list.isEmpty()) {
            this.viewList.addAll(list);
        }
        notifyDataSetChanged();
    }

    List<String> getData() {
        if (viewList == null) {
            viewList = new ArrayList<>();
        }

        return viewList;
    }
}
