package com.seatel.mobilehall.ui.home.adapter;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Filter;
import android.widget.Filterable;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import com.seatel.mobilehall.R;
import com.seatel.mobilehall.ui.packages.model.TableSubModel;

import java.util.ArrayList;
import java.util.List;

public class InternationalCallSubAdapter extends RecyclerView.Adapter<RecyclerView.ViewHolder> implements Filterable {

    private final Context mContext;
    private final List<TableSubModel> mTableModel;
    private List<TableSubModel> mTableModelDisplay;
    private final int VIEW_TYPE_TITLE = 0;
    private final int VIEW_TYPE_SUBTITLE = 1;

    public InternationalCallSubAdapter(Context mContext, List<TableSubModel> tableModel) {
        this.mContext = mContext;
        this.mTableModel = tableModel;
        this.mTableModelDisplay = mTableModel;
    }

    @NonNull
    @Override
    public RecyclerView.ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        return new DetailViewHolder(LayoutInflater.from(mContext).inflate(R.layout.item_international_call_sub, parent, false));
    }

    @Override
    public void onBindViewHolder(@NonNull RecyclerView.ViewHolder holder, int position) {
        ((DetailViewHolder) holder).onBind(mTableModelDisplay.get(position));
    }

    @Override
    public int getItemViewType(int position) {

        if (position == 0) return VIEW_TYPE_TITLE;
        else return VIEW_TYPE_SUBTITLE;
    }

    @Override
    public int getItemCount() {
        return mTableModelDisplay.size();
    }

    @Override
    public Filter getFilter() {

        return new Filter() {
            @Override
            protected FilterResults performFiltering(CharSequence constraint) {
                String charString = constraint.toString();
                if (charString.isEmpty()) {
                    mTableModelDisplay = mTableModel;
                } else {
                    List<TableSubModel> filteredList = new ArrayList<>();
                    TableSubModel tableSubModel = new TableSubModel(charString, "");

                    int index = mTableModel.indexOf(tableSubModel);
                    if (index != -1) {
                        filteredList.add(mTableModel.get(index));
                    }
                    mTableModelDisplay = filteredList;
                }

                FilterResults filterResults = new FilterResults();
                filterResults.values = mTableModelDisplay;
                return filterResults;
            }

            @Override
            protected void publishResults(CharSequence constraint, FilterResults results) {
                mTableModelDisplay = (List<TableSubModel>) results.values;
                notifyDataSetChanged();
            }
        };
    }


    private class DetailViewHolder extends RecyclerView.ViewHolder {

        private final TextView mDestination;
        private final TextView mCountryCode;

        private DetailViewHolder(View itemView) {
            super(itemView);
            mDestination = itemView.findViewById(R.id.ctv_destination);
            mCountryCode = itemView.findViewById(R.id.ctv_country_code);

        }

        private void onBind(TableSubModel tableModel) {
            mDestination.setText(tableModel.getDestination());
            mCountryCode.setText(tableModel.getCountryCode());

        }
    }
}
