package com.seatel.mobilehall.ui.home.adapter

import android.content.Context
import android.util.Log
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.view.animation.AnimationUtils
import android.widget.Button
import android.widget.TextView
import androidx.recyclerview.widget.RecyclerView
import com.seatel.mobilehall.R
import com.seatel.mobilehall.ui.base.adapter.BaseAdapter
import com.seatel.mobilehall.ui.home.interactor.ProductServiceButtonClick
import com.seatel.mobilehall.ui.home.model.ValuePackTableModel
import com.seatel.mobilehall.ui.login.activity.LoginActivity

class AddOnAdapter(
    private var context: Context,
    private var canSubscribe: Boolean,
    private var addOnList: List<ValuePackTableModel>,
    private var productServiceListener: ProductServiceButtonClick,
    private var getMainPhoneLogin: String
) :
    BaseAdapter<AddOnAdapter.ViewHolder>() {

    class ViewHolder(view: View) : RecyclerView.ViewHolder(view) {
        val mFee = itemView.findViewById<TextView>(R.id.tv_fee)
        val mData = itemView.findViewById<TextView>(R.id.tv_data)
        val mValidity = itemView.findViewById<TextView>(R.id.tv_validity)
        val mActivate = itemView.findViewById<TextView>(R.id.tv_activate)
        val mActivation = itemView.findViewById<Button>(R.id.btn_activate)
    }

    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): ViewHolder {
        return ViewHolder(
            LayoutInflater.from(context).inflate(R.layout.item_add_on_package, parent, false)
        )
    }

    override fun onBindViewHolder(holder: ViewHolder, position: Int) {
        setMyAnimation(
            holder.itemView,
            position,
            AnimationUtils.loadAnimation(context, R.anim.anim_recycler_item_horizontal)
        )
        val mAddOnList = addOnList[position]
        holder.mFee.text = mAddOnList.valuePrice
        holder.mData.text = mAddOnList.priceChange
        holder.mValidity.text = mAddOnList.validityDate
        holder.mActivate.text = mAddOnList.activation
        Log.d("activeBtn:>>", "onBindViewHolder:${mAddOnList.activateBtn}")
        if (canSubscribe && mAddOnList.activateBtn)
            holder.mActivation.visibility = View.VISIBLE
        holder.mActivation.setOnClickListener {
            val delay = mAddOnList.validityDate
            val separated: List<String> = delay.split(" ")

            when {
               // getMainPhoneLogin.isEmpty() -> LoginActivity.lunch(context)
                canSubscribe -> productServiceListener.confirmBuy(
                    mAddOnList.validityDate,
                    mAddOnList.valuePrice,
                    mAddOnList.priceChange, "",
                    true
                )
            }

        }
    }

    override fun getItemCount(): Int {
        return addOnList.size
    }
}