package com.seatel.mobilehall.ui.base.fragment

import android.content.Context
import android.os.Bundle
import android.text.TextUtils
import android.util.Log
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.Toast
import androidx.fragment.app.Fragment
import com.seatel.mobilehall.data.prefs.SeatelSharePreferences
import com.seatel.mobilehall.ui.login.model.ProfileModel
import com.google.gson.Gson

abstract class BaseFragment : Fragment() {

    private lateinit var mContext: Context
    private var mLayoutId: Int = 0

    override fun onCreateView(
        inflater: LayoutInflater,
        container: ViewGroup?,
        savedInstanceState: Bundle?
    ): View? {
       // return super.onCreateView(inflater, container, savedInstanceState)
        return LayoutInflater.from(mContext).inflate(getFragmentLayoutId(), container, false)
    }

    fun setFragmentLayout(layoutId: Int) {
        this.mLayoutId = layoutId
    }

    fun getFragmentLayoutId(): Int {
        return mLayoutId
    }


    fun getmContext(): Context {
        return mContext
    }

    fun setmContext(mContext: Context) {
        this.mContext = mContext
    }

    open fun isKeyboardHided(): Boolean {
        return false
    }

    open fun hideKeyBoard() {

    }

    open fun onBackPress() {}

    /*Show toast*/
    protected fun showToast(msg: String) {
        Toast.makeText(context, msg, Toast.LENGTH_LONG).show()
    }

    /*Log debug*/
    protected fun showLog(key: String, value: String) {
        Log.d(key, value)
    }

    fun getMainPhoneLogin(): String {
        return SeatelSharePreferences.getInstance(requireContext())?.getMainPhoneLogin()!!
    }

    fun getPhoneLogin(): String {
        return SeatelSharePreferences.getInstance(requireContext())?.getPhoneLogin()!!
    }

    fun getProfile(): ProfileModel {
        return if (!TextUtils.isEmpty(
                SeatelSharePreferences.getInstance(requireContext())?.getUserInfo()
            )
        )
            Gson().fromJson(
                SeatelSharePreferences.getInstance(requireContext())?.getUserInfo(),
                ProfileModel::class.java
            )
        else ProfileModel()
    }

    fun isPostPaidAccount(): Boolean {
        return SeatelSharePreferences.getInstance(requireContext())?.getIsPostPaid()!!
    }



}