package com.seatel.mobilehall.ui.home.adapter

import android.content.Context
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import androidx.core.content.ContextCompat
import androidx.recyclerview.widget.RecyclerView
import com.seatel.mobilehall.R
import com.seatel.mobilehall.databinding.ItemNearestYesHubLocationBinding
import com.seatel.mobilehall.ui.base.adapter.BaseAdapter
import com.seatel.mobilehall.ui.home.activity.YesHubNearestActivity
import com.seatel.mobilehall.ui.home.interactor.LocationShopMapInteractor
import com.seatel.mobilehall.ui.home.model.SeatelShopLocationModel
import com.seatel.mobilehall.util.SeatelUtils

class NearestYesHubLocationAdapter(
    private var items: ArrayList<SeatelShopLocationModel>,
    val context: Context
) : BaseAdapter<NearestYesHubLocationAdapter.ViewHolder>() {

    private var isShowOnlyLocalArea = false
    private lateinit var mLocationInterator: LocationShopMapInteractor
    private var positionSelect = -1

    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): ViewHolder {
        // Use ViewBinding to inflate the layout
        val binding =
            ItemNearestYesHubLocationBinding.inflate(LayoutInflater.from(context), parent, false)
        return ViewHolder(binding)
    }

    fun setClickLocalAreaSearch(onstartSearch: LocationShopMapInteractor) {
        this.mLocationInterator = onstartSearch
    }

    fun removeAll() {
        items = ArrayList<SeatelShopLocationModel>()
        notifyDataSetChanged()
    }

    fun updatedDataLocation(item: ArrayList<SeatelShopLocationModel>, showName: Boolean) {
        this.items.addAll(item)
        this.isShowOnlyLocalArea = showName
        notifyDataSetChanged()
    }

    override fun getItemCount(): Int {
        return items.size
    }

    override fun onBindViewHolder(holder: ViewHolder, position: Int) {
        holder.bindView(items[position], isShowOnlyLocalArea)
        holder.binding.root.setBackgroundColor(
            ContextCompat.getColor(
                context,
                android.R.color.transparent
            )
        )

        holder.binding.root.setOnClickListener {
            if (isShowOnlyLocalArea) {
                holder.binding.root.setBackgroundColor(
                    ContextCompat.getColor(
                        context,
                        android.R.color.transparent
                    )
                )
                positionSelect = -1
                (context as YesHubNearestActivity).showYesButton(positionSelect, null)
                mLocationInterator.onStartSearch(items[position].localArea)
            } else {
                if (positionSelect == position) {
                    positionSelect = -1
                    holder.binding.root.setBackgroundColor(
                        ContextCompat.getColor(
                            context,
                            android.R.color.transparent
                        )
                    )
                    holder.binding.btnCheck.visibility = View.INVISIBLE
                    (context as YesHubNearestActivity).showYesButton(positionSelect, null)
                } else {
                    notifyItemChanged(positionSelect)
                    positionSelect = position
                    holder.binding.root.setBackgroundColor(
                        ContextCompat.getColor(
                            context,
                            R.color.colorPinkSoft
                        )
                    )
                    holder.binding.btnCheck.visibility = View.VISIBLE
                    (context as YesHubNearestActivity).showYesButton(position, items[position])
                }
            }
        }

        if (isShowOnlyLocalArea) {
            holder.binding.btnCheck.visibility = View.GONE
            holder.binding.tvPhone.visibility = View.GONE
            holder.binding.tvTitle.visibility = View.GONE
            holder.binding.imgCall.visibility = View.GONE
        } else {
            if (positionSelect == position) {
                holder.binding.btnCheck.visibility = View.VISIBLE
            } else {
                holder.binding.btnCheck.visibility = View.INVISIBLE
            }
            holder.binding.tvPhone.visibility = View.VISIBLE
            holder.binding.tvTitle.visibility = View.VISIBLE
            holder.binding.imgCall.visibility = View.VISIBLE
        }
    }

    class ViewHolder(val binding: ItemNearestYesHubLocationBinding) :
        RecyclerView.ViewHolder(binding.root) {
        var isShowLocalArea = false

        fun bindView(rowData: SeatelShopLocationModel, showLocalArea: Boolean) {
            isShowLocalArea = showLocalArea
            if (isShowLocalArea)
                binding.tvAddress.text = rowData.localArea
            else
                binding.tvAddress.text = rowData.address

            binding.tvTitle.text = rowData.name
            binding.tvPhone.text = SeatelUtils.getPhoneFormatWithOutCode(rowData.contactNumber)
        }
    }
}
