package com.seatel.mobilehall.ui.home.activity

import android.content.Context
import android.content.Intent
import android.os.Bundle
import android.util.Log
import android.view.View
import androidx.core.content.ContextCompat
import androidx.recyclerview.widget.LinearLayoutManager
import com.android.volley.NoConnectionError
import com.android.volley.TimeoutError
import com.android.volley.VolleyError
import com.seatel.mobilehall.R
import com.seatel.mobilehall.databinding.ActivityProductServiceDetailBinding
import com.seatel.mobilehall.ui.base.activity.BaseActivity
import com.seatel.mobilehall.ui.home.adapter.AddOnAdapter
import com.seatel.mobilehall.ui.home.adapter.ProductServiceDetailAdapter
import com.seatel.mobilehall.ui.home.adapter.TermAndServiceFooterAdapter
import com.seatel.mobilehall.ui.home.interactor.ProductServiceButtonClick
import com.seatel.mobilehall.ui.home.interactor.ProductServiceDetailInteractor
import com.seatel.mobilehall.ui.home.model.MainDataModel
import com.seatel.mobilehall.ui.home.model.ValuePackSectionModel
import com.seatel.mobilehall.ui.home.model.ValuePackTableModel
import com.seatel.mobilehall.ui.home.presenter.ProductServiceDetailPrsenter
import com.seatel.mobilehall.util.customview.ErrorHandleView

class ProductServiceDetailActivity : BaseActivity<ActivityProductServiceDetailBinding>(),
    View.OnClickListener,
    ProductServiceDetailInteractor.View, ProductServiceButtonClick {

    companion object {
        fun launch(
            context: Context, canSubscribe: Boolean, planCode: String, title: String
        ) {
            val intent = Intent(context, ProductServiceDetailActivity::class.java)
            intent.putExtra("PLAN_CODE", planCode)
            intent.putExtra("CAN_SUBSCRIBE", canSubscribe)
            intent.putExtra("TITLE", title)
            context.startActivity(intent)
        }

    }

    private var dataMainScreen: MainDataModel? = null
    private var mPlanCode: String? = null
    private var canSubscribe: Boolean = false
    private var valueData: String? = null
    private var name: String? = null
    private var title: String = ""
    override fun getViewBinding(): ActivityProductServiceDetailBinding {
        return ActivityProductServiceDetailBinding.inflate(layoutInflater)
    }


    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
    //    setContentView(R.layout.activity_product_service_detail)
        activityEnterRightAnimation()
        binding.errorView.setViewMode(ErrorHandleView.Mode.LOADING)
        getDataIntent()
        init()
    }

    private fun getDataIntent() {
        canSubscribe = intent.getBooleanExtra("CAN_SUBSCRIBE", false)
        mPlanCode = intent.getStringExtra("PLAN_CODE")

    }


    override fun onResume() {
        super.onResume()
        init()
    }


    private fun init() {
        ProductServiceDetailPrsenter(this, this).onProServiceDetail(mPlanCode!!, getPhoneLogin())
        binding.btnBenefit.setOnClickListener(this)
        binding.btnTermCondition.setOnClickListener(this)
    }

    override fun onClick(view: View?) {
        when (view?.tag) {
            "BUTTON_BENEFIT" -> {
                binding.frameBenefit.visibility = View.VISIBLE
                binding.btnBenefit.setTextColor(ContextCompat.getColor(this, R.color.colorPrimary))
                binding.btnBenefit.setBackgroundResource(R.drawable.bg_button_cart)
                binding.btnBenefit.isAllCaps = true

                //term condition button
                binding.frameTermCondition.visibility = View.GONE
                binding.btnTermCondition.setTextColor(ContextCompat.getColor(this, R.color.black))
                binding.btnTermCondition.setBackgroundColor(resources.getColor(R.color.colorItemDataPack))

            }

            "BUTTON_TERM_CONDITION" -> {
                binding.frameTermCondition.visibility = View.VISIBLE
                binding.btnTermCondition.setTextColor(
                    ContextCompat.getColor(
                        this,
                        R.color.colorPrimary
                    )
                )
                binding.btnTermCondition.setBackgroundResource(R.drawable.bg_button_cart)
                binding.btnTermCondition.isAllCaps = true

                //Benefit button
                binding.frameBenefit.visibility = View.GONE
                binding.btnBenefit.setTextColor(ContextCompat.getColor(this, R.color.black))
                binding.btnBenefit.setBackgroundColor(resources.getColor(R.color.colorItemDataPack))

            }
        }
    }

    override fun getToolbarTitle(): String {
        return intent.getStringExtra("TITLE").toString()
    }

    override fun onProServiceDetailSucceed(valuePackSectionModel: ValuePackSectionModel) {
        binding.errorView.visibility = View.GONE
        if (valuePackSectionModel.type == "loy-kobs") {
            binding.callSms.visibility = View.VISIBLE
        }
        if (valuePackSectionModel.valuePackSecThreeModel.description2.isNotEmpty()) {
            binding.tvAddOnTermCondition.text = "Add-on Terms & Conditions"
        }
        if (valuePackSectionModel.valuePackSecTwoModel.addon.size > 0)
            binding.addonFrame.visibility = View.VISIBLE
        else
            binding.addonFrame.visibility = View.GONE
        valueData = valuePackSectionModel.type
        name = valuePackSectionModel.name
        setupTitle(valuePackSectionModel)
        (valuePackSectionModel)
    }

    private fun setupTitle(valuePackSectionModel: ValuePackSectionModel) {
        binding.mainTitle.text = valuePackSectionModel.valuePackSecTwoModel.title
        binding.subTitle.text = valuePackSectionModel.valuePackSecTwoModel.subTitle
    }

    private fun setupDataList(valuePackSectionModel: ValuePackSectionModel) {
        binding.mRecyclerPackage.adapter =
            ProductServiceDetailAdapter(
                this,
                canSubscribe,
                valuePackSectionModel.valuePackSecTwoModel.table, this, getMainPhoneLogin()
            )
        binding.mRecyclerAddOn.apply {
            layoutManager = LinearLayoutManager(context, LinearLayoutManager.HORIZONTAL, false)
            adapter = AddOnAdapter(
                context,
                canSubscribe,
                valuePackSectionModel.valuePackSecTwoModel.addon,
                this@ProductServiceDetailActivity,
                getMainPhoneLogin()
            )
        }
        binding.mRecyclerTermCondition.adapter = TermAndServiceFooterAdapter(
            this, getTermAndServiceEn(valuePackSectionModel.valuePackSecThreeModel.description),
            true
        )

        binding.mRecyclerAddOnTermCondition.adapter = TermAndServiceFooterAdapter(
            this,
            getTermAndServiceEn(valuePackSectionModel.valuePackSecThreeModel.description2),
            true
        )
    }


    private fun getTermAndServiceEn(str: String): List<String> {
        val data = ArrayList<String>()
        data.add(str)
        return data
    }

    override fun onProServiceDetailFailed(error: VolleyError) {
        Log.e("ResponseError::>>>", "onProServiceDetailFailed: ${error.message}")
        when (error) {
            is TimeoutError -> {
                binding.errorView.errorMessage = getString(R.string.connection_timeout)
                binding.errorView.setViewMode(ErrorHandleView.Mode.TIME_OUT)
            }

            is NoConnectionError -> {
                binding.errorView.errorMessage = getString(R.string.message_no_internet)
                binding.errorView.setViewMode(ErrorHandleView.Mode.NO_INTERNET)
            }

            else -> {
                binding.errorView.errorMessage = getString(R.string.no_data)
                binding.errorView.setViewMode(ErrorHandleView.Mode.NO_DATA)
            }
        }
    }

    override fun buttonActive(
        dataValuePack: ValuePackTableModel,
        amountMB: String,
        pricetMB: String,
        account: String,
        dayPlan: Int,
        type: String
    ) {


//        when (mPlanCode) {
//            "loy-kob" -> {
//                ConfirmBuyDataPackActivity.lunchFromValuePack(
//                    this,
//                    dataValuePack,
//                    type,
//                    isloykob = true
//                )
//            }
//            "fortune-pack" -> {
//                ConfirmBuyDataPackActivity.lunchFromValuePack(
//                    this,
//                    dataValuePack,
//                    type,
//                    isFortunePlan = true
//                )
//            }
//            "value-pack" -> {
//                ConfirmBuyDataPackActivity.lunchFromValuePack(this, dataValuePack, type)
//            }
//            "vip-fortune-pack" -> {
//                ConfirmBuyDataPackActivity.lunchFromValuePack(
//                    this,
//                    dataValuePack,
//                    type,
//                    isVipFortunePlan = true
//                )
//            }
//            else -> {
//                dataMainScreen = Gson().fromJson(
//                    SeatelSharePreferences.getInstance(this)?.getMainScreenData(),
//                    MainDataModel::class.java
//                )
//                val phoneNumber = SeatelUtils.phoneNumberFormat(dataMainScreen?.getPhonNumber())
//                ConfirmBuyDataPackActivity.lunchFromDataPack(
//                    this,
//                    amountMB,
//                    pricetMB,
//                    phoneNumber,
//                    dayPlan,
//                    false,
//                    type
//                )
//            }
//        }
    }

    override fun confirmBuy(
        validity: String,
        fee: String,
        data: String,
        pricePlanCode: String,
        isAddon: Boolean
    ) {
        when {

            isAddon -> ConfirmBuyDataPackActivity.launch(
                this,
                name!!,
                valueData!!,
                validity,
                fee,
                data,
                pricePlanCode,
                true
            )

            else -> ConfirmBuyDataPackActivity.launch(
                this,
                name!!,
                valueData!!,
                validity,
                fee,
                data,
                pricePlanCode,
                false
            )
        }
    }


}