package com.seatel.mobilehall.util.view

import android.content.Context
import android.text.TextUtils
import android.util.AttributeSet
import android.view.LayoutInflater
import android.view.View
import android.widget.RelativeLayout
import androidx.core.content.ContextCompat
import com.seatel.mobilehall.R
import kotlinx.android.synthetic.main.view_item_data_pack.view.*

class ItemDataPackView @JvmOverloads constructor(
    context: Context, attrs: AttributeSet? = null, defStyleAttr: Int = 0
) : RelativeLayout(context, attrs, defStyleAttr) {
    init {
        initView()
    }

    private fun initView() {
        LayoutInflater.from(context).inflate(R.layout.view_item_data_pack, this)
    }

    fun setValueData(
        price: String,
        size: String,
        strPeriod: String,
        strMb: String,
        isBuyFree: Boolean = false
    ) {
        ctv_value_price.text = price.replace(",", ".")
        ctv_value.text = size
        tv_day_peroid.text = strPeriod
        tv_size_type.text = strMb
        if (isBuyFree) {
            img_buy_free.visibility = View.GONE
        }
    }

    fun isSelectedRow(): Boolean {
        val selected = layout_main.tag as String
        return (TextUtils.equals(selected, "true"))
    }

    fun reset() {
        img_check.visibility = View.INVISIBLE
        layout_main.background = ContextCompat.getDrawable(context, R.drawable.bg_item_data_pack)
        layout_main.tag = "false"
    }

    fun onSelectItem() {
        val selected = layout_main.tag as String
        if (TextUtils.equals(selected, "false")) {
            img_check.visibility = View.VISIBLE
            layout_main.background =
                ContextCompat.getDrawable(context, R.drawable.bg_item_data_pack_selected)
            layout_main.tag = "true"
        } else {
            img_check.visibility = View.INVISIBLE
            layout_main.background =
                ContextCompat.getDrawable(context, R.drawable.bg_item_data_pack)
            layout_main.tag = "false"
        }
    }

}