package com.seatel.mobilehall.ui.home.adapter

import android.content.Context
import android.content.Intent
import android.net.Uri
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import androidx.recyclerview.widget.RecyclerView
import com.seatel.mobilehall.R
import com.seatel.mobilehall.ui.base.adapter.BaseAdapter
import com.seatel.mobilehall.ui.home.activity.ContactUsActivity
import com.seatel.mobilehall.ui.home.activity.LocationShopMapActivity
import com.seatel.mobilehall.ui.home.interactor.LocationShopMapInteractor
import com.seatel.mobilehall.ui.home.model.SeatelShopLocationModel
import com.seatel.mobilehall.util.SeatelUtils
import com.google.gson.Gson
import kotlinx.android.synthetic.main.item_shop_location.view.*


class ShopLocationAdapter(var items: ArrayList<SeatelShopLocationModel>, val context: Context) :
    BaseAdapter<ShopLocationAdapter.ViewHolder>() {

    private var isShowOnlyLocalArea = false
    private lateinit var mLocationInterator: LocationShopMapInteractor

    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): ViewHolder {

        return ViewHolder(
            LayoutInflater.from(context).inflate(R.layout.item_shop_location, parent, false)
        )

    }

    fun setClickLocalAreaSearch(onstartSearch: LocationShopMapInteractor) {
        this.mLocationInterator = onstartSearch
    }

    fun removeAll() {
        items = ArrayList<SeatelShopLocationModel>()
        notifyDataSetChanged()
    }

    fun updatedDataLocation(item: ArrayList<SeatelShopLocationModel>, showName: Boolean) {
//        this.items.clear()
        this.items.addAll(item) //= ArrayList<SeatelShopLocationModel>(items)
        this.isShowOnlyLocalArea = showName
        notifyDataSetChanged()

    }

    override fun getItemCount(): Int {
        return items.size
    }

    override fun onBindViewHolder(holder: ViewHolder, position: Int) {
//        if (getLastPosition() == -1) {
//            holder.itemView.visibility = View.INVISIBLE
//        }
//        setAnimation(holder.itemView, position)

        holder.bindView(items[position], isShowOnlyLocalArea)
        holder.itemView.setOnClickListener {
            if (isShowOnlyLocalArea) {
                mLocationInterator.onStartSearch(items[position].localArea)
            } else {
                ContactUsActivity.lunch(context, Gson().toJson(items[position]))
            }
        }

        if (isShowOnlyLocalArea) {
            holder.itemView.btn_direction.visibility = View.GONE
            holder.itemView.tv_phone.visibility = View.GONE
            holder.itemView.tv_title.visibility = View.GONE
            holder.itemView.img_call.visibility = View.GONE
        } else {
            holder.itemView.btn_direction.visibility = View.VISIBLE
            holder.itemView.tv_phone.visibility = View.VISIBLE
            holder.itemView.tv_title.visibility = View.VISIBLE
            holder.itemView.img_call.visibility = View.VISIBLE
        }

        holder.itemView.btn_direction.setOnClickListener {
            val intent = Intent(
                android.content.Intent.ACTION_VIEW,
                Uri.parse("http://maps.google.com/maps?daddr=" + "${items[position].latitude},${items[position].longitude}")
            )
            context.startActivity(intent)
        }
        holder.itemView.phone_call.setOnClickListener {
            (context as LocationShopMapActivity).showCallDialog(items[position].contactNumber)
        }
    }

    class ViewHolder(view: View) : RecyclerView.ViewHolder(view) {
        var isShowLocalArea = false
        val tvTitle = view.tv_title
        val tvAddress = view.tv_address
        val tvPhone = view.tv_phone

        fun bindView(rowData: SeatelShopLocationModel, showLocalArea: Boolean) {
            isShowLocalArea = showLocalArea
            if (isShowLocalArea)
                tvAddress.text = rowData.localArea
            else
                tvAddress.text = rowData.address

            tvTitle.text = rowData.name
            tvPhone.text = SeatelUtils.getPhoneFormatWithOutCode(rowData.contactNumber)
        }
    }

}