package com.seatel.mobilehall.ui.mysterybox

import android.content.Context
import com.google.gson.Gson
import com.google.gson.reflect.TypeToken
import com.seatel.mobilehall.data.network.SeatelJSONArrayRequest
import org.json.JSONArray

class ValentinePresenter(
    private var mContext: Context,
    private var angPaoInteractor: ValentineInteractor.View
) : ValentineInteractor.Presenter {


    override fun getValentineReward(phoneNumber: String) {
        valentineRequest(phoneNumber).setOnErrorListener { error ->
            angPaoInteractor.onValentineRewardFailed(error)
        }.setOnResponseListener { response ->
            angPaoInteractor.onValentineRewardSucceed(getResponseValentine(response as JSONArray))
        }.execute()
    }


    private fun getResponseValentine(response: JSONArray): ArrayList<MysteryBoxModelItem> {
        val itemType = object : TypeToken<List<MysteryBoxModelItem>>() {}.type
        return Gson().fromJson(response.toString(), itemType)
    }


    private fun valentineRequest(phoneNumber: String): SeatelJSONArrayRequest {

        return object : SeatelJSONArrayRequest(mContext) {
            override fun getFunctionName(): String {
                return "v2/seatel/get-prize/$phoneNumber/mystery-box"
            }
        }
    }
}