package com.seatel.mobilehall.util.customview

import android.content.Context
import android.util.AttributeSet
import android.view.LayoutInflater
import android.view.View
import android.widget.LinearLayout
import androidx.core.content.ContextCompat
import com.seatel.mobilehall.R
import kotlinx.android.synthetic.main.view_order_section.view.*

class OrderSectionView @JvmOverloads constructor(
    context: Context,
    attrs: AttributeSet? = null,
    defStyleAttr: Int = 0
) : LinearLayout(context, attrs, defStyleAttr) {

    init {
        LayoutInflater.from(context).inflate(R.layout.view_order_section, this)
    }

    fun setViewForClaimFreeSim() {
        frame_four.visibility = View.GONE
    }

    fun setSection(section: Int) {
        frame_two.setBackgroundColor(ContextCompat.getColor(context, R.color.section_grey))
        frame_three.setBackgroundColor(ContextCompat.getColor(context, R.color.section_grey))
        frame_four.setBackgroundColor(ContextCompat.getColor(context, R.color.section_grey))

        image_view_two.setImageResource(R.drawable.ic_section_2_grey)
        image_view_three.setImageResource(R.drawable.ic_section_3_grey)
        image_view_four.setImageResource(R.drawable.ic_section_4_grey)

        text_view_two.setTextColor(ContextCompat.getColor(context, R.color.section_grey))
        text_view_three.setTextColor(ContextCompat.getColor(context, R.color.section_grey))
        text_view_four.setTextColor(ContextCompat.getColor(context, R.color.section_grey))

        if (section > 1) {
            frame_two.setBackgroundColor(ContextCompat.getColor(context, R.color.colorPrimary))
            image_view_two.setImageResource(R.drawable.ic_section_2_primary)
            text_view_two.setTextColor(ContextCompat.getColor(context, R.color.colorPrimary))
        }
        if (section > 2) {
            frame_three.setBackgroundColor(ContextCompat.getColor(context, R.color.colorPrimary))
            image_view_three.setImageResource(R.drawable.ic_section_3_primary)
            text_view_three.setTextColor(ContextCompat.getColor(context, R.color.colorPrimary))
        }
        if (section > 3) {
            frame_four.setBackgroundColor(ContextCompat.getColor(context, R.color.colorPrimary))
            image_view_four.setImageResource(R.drawable.ic_section_4_primary)
            text_view_four.setTextColor(ContextCompat.getColor(context, R.color.colorPrimary))
        }

    }
}