package com.seatel.mobilehall.util.customview

import android.app.Dialog
import android.content.Context
import android.graphics.Color
import android.graphics.drawable.ColorDrawable
import android.view.Gravity
import android.view.LayoutInflater
import android.view.Window
import android.view.WindowManager
import androidx.recyclerview.widget.LinearLayoutManager
import androidx.recyclerview.widget.RecyclerView
import com.seatel.mobilehall.R
import com.seatel.mobilehall.util.customview.adapter.BottomChooserAdapter
import kotlinx.android.synthetic.main.dialog_bottom_chooser.view.*

@Suppress("RECEIVER_NULLABILITY_MISMATCH_BASED_ON_JAVA_ANNOTATIONS")
class BottomChooserDialog(context: Context) : Dialog(context) {

    private val recyclerView: RecyclerView

    init {
        val view = LayoutInflater.from(context).inflate(R.layout.dialog_bottom_chooser, null)
        requestWindowFeature(Window.FEATURE_NO_TITLE)
        setContentView(view)
        if (this.window != null) {
            this.window?.setDimAmount(0.5f)
            this.window?.setLayout(
                WindowManager.LayoutParams.MATCH_PARENT,
                WindowManager.LayoutParams.WRAP_CONTENT
            )
            this.window?.setBackgroundDrawable(ColorDrawable(Color.TRANSPARENT))
            this.window?.setGravity(Gravity.BOTTOM)
            this.window?.attributes?.windowAnimations = R.style.DialogAnimationSlideUpDown
        }
        recyclerView = view.findViewById(R.id.rv_chooser)
        recyclerView.layoutManager = LinearLayoutManager(context)

        view.button_cancel.setOnClickListener {
            dismiss()
        }
    }

    fun addItems(
        bottomChooserModels: ArrayList<BottomChooserModel>,
        onItemChooser: OnItemChooser
    ): BottomChooserDialog {
        val bottomChooserAdapter = BottomChooserAdapter()
        bottomChooserAdapter.addItems(
            bottomChooserModels,
            object : BottomChooserAdapter.OnItemClick {
                override fun onClick(position: Int, data: BottomChooserModel) {
                    onItemChooser.onChose(position, data)
                    dismiss()
                }
            })
        recyclerView.adapter = bottomChooserAdapter

        return this
    }

    interface OnItemChooser {
        fun onChose(position: Int, data: BottomChooserModel)
    }


    class BottomChooserModel(var id: Int, var name: String)
}
