package com.seatel.mobilehall.util

import android.app.Dialog
import android.content.Context
import android.graphics.Color
import android.graphics.drawable.ColorDrawable
import android.view.Gravity
import android.view.LayoutInflater
import android.view.Window
import android.view.WindowManager
import androidx.recyclerview.widget.LinearLayoutManager
import androidx.recyclerview.widget.RecyclerView
import com.seatel.mobilehall.R
import com.seatel.mobilehall.ui.invite_friend.BottomInviteFriendAdapter
import kotlinx.android.synthetic.main.dialog_bottom_chooser.view.*

@Suppress("RECEIVER_NULLABILITY_MISMATCH_BASED_ON_JAVA_ANNOTATIONS")
class BottomInviteFriendDialog(context: Context) : Dialog(context) {

    private val recyclerView: RecyclerView

    init {
        val view = LayoutInflater.from(context).inflate(R.layout.dialog_bottom_invite_friend, null)
        requestWindowFeature(Window.FEATURE_NO_TITLE)
        setContentView(view)
        if (this.window != null) {
            this.window!!.setDimAmount(0.5f)
            this.window!!.setLayout(
                WindowManager.LayoutParams.MATCH_PARENT,
                WindowManager.LayoutParams.WRAP_CONTENT
            )
            this.window!!.setBackgroundDrawable(ColorDrawable(Color.TRANSPARENT))
            this.window!!.setGravity(Gravity.CLIP_VERTICAL)
            this.window!!.attributes.windowAnimations = R.style.DialogAnimationScaleInOut
            // this.window!!.attributes.windowAnimations = R.style.DialogAnimationSlideUpDown
        }
        recyclerView = view.findViewById(R.id.rv_chooser)
        recyclerView.layoutManager = LinearLayoutManager(context)

        view.button_cancel.setOnClickListener {
            dismiss()
        }
    }


    fun addFriendNumber(
        bottomChooserModels: ArrayList<BottomInviteFriendModel>
    ): BottomInviteFriendDialog {
        val bottomInviteFriendAdapter = BottomInviteFriendAdapter()
        bottomInviteFriendAdapter.addItems(bottomChooserModels,
            object : BottomInviteFriendAdapter.OnItemClick {
                override fun onClick(
                    position: Int,
                    data: BottomInviteFriendDialog.BottomInviteFriendModel
                ) {

                }

                override fun onDelete(
                    position: Int,
                    data: BottomInviteFriendDialog.BottomInviteFriendModel
                ) {

                }


            })
        recyclerView.adapter = bottomInviteFriendAdapter
        return this
    }


    class BottomAccountChooserModel(var id: String, var name: String, var deleted: Boolean)
    class BottomInviteFriendModel(
        var referee: String,
        var jonDate: String,
        var lastTopUpDate: String? = null
    )
}
