package com.seatel.mobilehall.util.view

import android.animation.ObjectAnimator
import android.content.Context
import android.util.AttributeSet
import android.view.LayoutInflater
import android.view.View
import android.view.ViewTreeObserver.OnGlobalLayoutListener
import android.widget.RelativeLayout
import androidx.core.content.ContextCompat
import androidx.fragment.app.FragmentActivity
import androidx.recyclerview.widget.LinearLayoutManager
import com.seatel.mobilehall.R
import com.seatel.mobilehall.ui.home.activity.DataPackActivity
import com.seatel.mobilehall.ui.home.adapter.DataStandardRateAdapter
import com.seatel.mobilehall.ui.home.adapter.TermAndServiceFooterAdapter
import com.seatel.mobilehall.ui.home.adapter.ValuePackDetailAdapter
import com.seatel.mobilehall.ui.home.model.ValuePackSectionModel
import com.seatel.mobilehall.util.Constant
import com.seatel.mobilehall.util.SeatelUtils
import com.seatel.mobilehall.util.customview.adapter.DataAirlineAdapter
import com.seatel.mobilehall.util.lang.LanguageManager
import kotlinx.android.synthetic.main.fragment_data_pack_introduction.view.*
import kotlinx.android.synthetic.main.fragment_data_standard_rate.view.*
import kotlinx.android.synthetic.main.view_data_pack_tab_footer.view.*


class ViewDataPackTabFooter @JvmOverloads constructor(
    context: Context, attrs: AttributeSet? = null, defStyleAttr: Int = 0
) : RelativeLayout(context, attrs, defStyleAttr), View.OnClickListener {

    private lateinit var activity: FragmentActivity
    private var lastMove: Float = 0f
    private var mIsValuePack = false
    private var mIsProduct = false
    private var mIsFortunePack = false
    private var mIsSeatelAirline = false
    private var mIsLanmeiAirline = false
    private var mAdapterValuePack: ValuePackDetailAdapter? = null
    private var mAdapterTermCondition: TermAndServiceFooterAdapter? = null
    private var mValuePackModel: ValuePackSectionModel? = null

    override fun onClick(v: View?) {
        if (v != null) {
            when (v.id) {
                R.id.layout_tab_introduction -> {
//                    ViewCompat.setBackground(layout_tab_standard_rate, ContextCompat.getDrawable(context, R.drawable.bg_tab_box_round_gray))
//                    ViewCompat.setBackground(layout_tab_introduction, ContextCompat.getDrawable(context, R.drawable.bg_tab_box_round_pink))
                    animateBoxMove(0f)
                    ctv_introduction.setTextColor(
                        ContextCompat.getColor(
                            context,
                            R.color.colorPrimary
                        )
                    )
                    ctv_standard_rate.setTextColor(
                        ContextCompat.getColor(
                            context,
                            R.color.colorTextBlack
                        )
                    )
                    layout_introduction.visibility = View.VISIBLE
                    layout_standard_rate.visibility = View.INVISIBLE
                }
                R.id.layout_tab_standard_rate -> {
//                    ViewCompat.setBackground(layout_tab_introduction, ContextCompat.getDrawable(context, R.drawable.bg_tab_box_round_gray))
//                    ViewCompat.setBackground(layout_tab_standard_rate, ContextCompat.getDrawable(context, R.drawable.bg_tab_box_round_pink))
                    animateBoxMove(view_box_animate.width.toFloat())
                    ctv_standard_rate.setTextColor(
                        ContextCompat.getColor(
                            context,
                            R.color.colorPrimary
                        )
                    )
                    ctv_introduction.setTextColor(
                        ContextCompat.getColor(
                            context,
                            R.color.colorTextBlack
                        )
                    )
                    layout_standard_rate.visibility = View.VISIBLE
                    layout_introduction.visibility = View.INVISIBLE
                }
            }
        }
    }

    init {
        initView()
    }

    private fun animateBoxMove(xPos: Float) {
        val transAnimation =
            ObjectAnimator.ofFloat(view_box_animate, "translationX", lastMove, xPos)
        transAnimation.duration = 300//set duration
        transAnimation.start()//start animation
        lastMove = xPos
    }

    fun setDataValuePackFooter(data: ValuePackSectionModel, strTerm: String, isProduct: Boolean) {
        mValuePackModel = data
        mIsProduct = isProduct
        mAdapterValuePack?.resetDataNew(data)
        if (mIsValuePack || mIsFortunePack || mIsLanmeiAirline || mIsSeatelAirline) {
            val dataTerm = ArrayList<String>()
            dataTerm.add(strTerm)
            mAdapterTermCondition?.resetDataNew(dataTerm)
        }
        mAdapterValuePack?.notifyDataSetChanged()
    }

    private fun initView() {

        if (context is DataPackActivity) {
            mIsValuePack =
                (context as DataPackActivity).intent.getBooleanExtra("IS_VALUE_PACK", false)
            mIsFortunePack =
                (context as DataPackActivity).intent.getBooleanExtra("FORTUNE_PACK", false)
            mIsSeatelAirline =
                (context as DataPackActivity).intent.getBooleanExtra("SEATEL_AIRLINE_PACK", false)
            mIsLanmeiAirline =
                (context as DataPackActivity).intent.getBooleanExtra("LANMEI_AIRLINE_PACK", false)
            mValuePackModel = (context as DataPackActivity).getData()
        }

        val lang = LanguageManager.getInstance(context).getLanguageCode()
        activity = context as FragmentActivity
        LayoutInflater.from(context).inflate(R.layout.view_data_pack_tab_footer, this)
        layout_tab_introduction.setOnClickListener(this)
        layout_tab_standard_rate.setOnClickListener(this)
        recycler_view_data_standard.layoutManager = LinearLayoutManager(context)
        recycler_view_term_and_service.layoutManager = LinearLayoutManager(context)

        if (mIsValuePack || mIsFortunePack) {
            mAdapterValuePack = if (mValuePackModel != null)
                ValuePackDetailAdapter(
                    context,
                    mValuePackModel!!,
                    true,
                    mIsFortunePack,
                    isFromProduct = mIsProduct
                )
            else
                ValuePackDetailAdapter(context, ValuePackSectionModel(), true, mIsFortunePack)

            recycler_view_data_standard.adapter = mAdapterValuePack
            text_internet_pack_title.visibility = View.GONE
        }

        when (lang) {
            Constant.KHMER -> {
                if (!mIsValuePack && !mIsFortunePack) {
                    if (mIsSeatelAirline || mIsLanmeiAirline) {
                        recycler_view_data_standard.adapter =
                            DataAirlineAdapter(context, getAirLineTable(2))
                        text_internet_pack_title.visibility = View.GONE
                    } else {
                        recycler_view_data_standard.adapter =
                            DataStandardRateAdapter(context, getTableData(2))
                        text_internet_pack_title.text = getInternetPackTitle(2)
                    }

                }
                mAdapterTermCondition = TermAndServiceFooterAdapter(
                    context,
                    getTermAndService(2),
                    mIsValuePack || mIsFortunePack || mIsSeatelAirline || mIsLanmeiAirline
                )
                recycler_view_term_and_service.adapter = mAdapterTermCondition
            }
            Constant.CHINESE -> {
                if (!mIsValuePack && !mIsFortunePack) {
                    if (mIsSeatelAirline || mIsLanmeiAirline) {
                        recycler_view_data_standard.adapter =
                            DataAirlineAdapter(context, getAirLineTable(1))
                        text_internet_pack_title.visibility = View.GONE
                    } else {
                        recycler_view_data_standard.adapter =
                            DataStandardRateAdapter(context, getTableData(1))
                        text_internet_pack_title.text = getInternetPackTitle(1)
                    }

                }
                mAdapterTermCondition = TermAndServiceFooterAdapter(
                    context,
                    getTermAndService(1),
                    mIsValuePack || mIsFortunePack || mIsSeatelAirline || mIsLanmeiAirline
                )
                recycler_view_term_and_service.adapter = mAdapterTermCondition
            }
            else -> {
                if (!mIsValuePack && !mIsFortunePack) {
                    if (mIsSeatelAirline || mIsLanmeiAirline) {
                        recycler_view_data_standard.adapter =
                            DataAirlineAdapter(context, getAirLineTable(3))
                        text_internet_pack_title.visibility = View.GONE
                    } else {
                        recycler_view_data_standard.adapter =
                            DataStandardRateAdapter(context, getTableData(3))
                        text_internet_pack_title.text = getInternetPackTitle(3)
                    }

                }
                mAdapterTermCondition = TermAndServiceFooterAdapter(
                    context,
                    getTermAndService(3),
                    mIsValuePack || mIsFortunePack || mIsSeatelAirline || mIsLanmeiAirline
                )
                recycler_view_term_and_service.adapter = mAdapterTermCondition
            }

        }

        val vto = layout_tab_introduction.viewTreeObserver
        vto.addOnGlobalLayoutListener(object : OnGlobalLayoutListener {
            override fun onGlobalLayout() {
                layout_tab_introduction.viewTreeObserver.removeOnGlobalLayoutListener(this)
                val width = layout_tab_introduction.measuredWidth
                val height = layout_tab_introduction.measuredHeight
                var param = LayoutParams(width, height)
                view_box_animate.layoutParams = param
            }
        })

    }

    private fun getAirLineTable(language: Int): List<TableModel> {
        var dayStr = SeatelUtils.translatForDialog(context, "Day")
        val tableDataList = ArrayList<TableModel>()
        val tableModel: TableModel
        when (language) {
            1 -> {
                tableModel = TableModel(
                    "30天",
                    listOf("$5"),
                    listOf("35GB"),
                    listOf("1800*662*"),
                    listOf("30天")
                )
                // tableModel1 = TableModel("7$dayStr", listOf("$1"), listOf("10 GB"), listOf("1800*333*"), listOf("7天"))
                // tableModel2 = TableModel("30$dayStr", listOf("$5", "$10"), listOf("45 GB", "100 GB"), listOf("1800*335*", "1800*336*"), listOf("30天", "30天"))
            }
            2 -> {
                tableModel = TableModel(
                    "30ថ្ងៃ",
                    listOf("$5"),
                    listOf("35GB"),
                    listOf("1800*662*"),
                    listOf("30ថ្ងៃ")
                )
                //  tableModel1 = TableModel("7$dayStr", listOf("$1"), listOf("10 GB"), listOf("1800*333*"), listOf("7ថ្ងៃ"))
                //  tableModel2 = TableModel("30$dayStr", listOf("$5", "$10"), listOf("45 GB", "100 GB"), listOf("1800*335*", "1800*336*"), listOf("30ថ្ងៃ", "30ថ្ងៃ"))
            }
            else -> {
                tableModel = TableModel(
                    "30-Day",
                    listOf("$5"),
                    listOf("35GB"),
                    listOf("1800*662*"),
                    listOf("30 Days")
                )
                //  tableModel1 = TableModel("7-Day", listOf("$1"), listOf("10 GB"), listOf("1800*333*"), listOf("7 Days"))
                //  tableModel2 = TableModel("30-Day", listOf("$5", "$10"), listOf("45 GB", "100 GB"), listOf("1800*335*", "1800*336*"), listOf("30 Days", "30 Days"))
            }
        }

        tableDataList.add(tableModel)
        //  tableDataList.add(tableModel1)
        //  tableDataList.add(tableModel2)

        return tableDataList
    }

    private fun getTableData(language: Int): List<TableModel> {
        var dayStr = SeatelUtils.translatForDialog(context, "Day")
        val tableDataList = ArrayList<TableModel>()
        var tableModel: TableModel
        var tableModel1: TableModel
        var tableModel2: TableModel
        when (language) {
            1 -> {
                tableModel = TableModel(
                    "1$dayStr",
                    listOf("$0.50"),
                    listOf("500 MB"),
                    listOf("1800*331*"),
                    listOf("1天")
                )
                tableModel1 = TableModel(
                    "7$dayStr",
                    listOf("$1"),
                    listOf("10 GB"),
                    listOf("1800*333*"),
                    listOf("7天")
                )
                tableModel2 = TableModel(
                    "30$dayStr",
                    listOf("$5", "$10"),
                    listOf("45 GB", "100 GB"),
                    listOf("1800*335*", "1800*336*"),
                    listOf("30天", "30天")
                )
            }
            2 -> {
                tableModel = TableModel(
                    "1$dayStr",
                    listOf("$0.50"),
                    listOf("500 MB"),
                    listOf("1800*331*"),
                    listOf("1ថ្ងៃ")
                )
                tableModel1 = TableModel(
                    "7$dayStr",
                    listOf("$1"),
                    listOf("10 GB"),
                    listOf("1800*333*"),
                    listOf("7ថ្ងៃ")
                )
                tableModel2 = TableModel(
                    "30$dayStr",
                    listOf("$5", "$10"),
                    listOf("45 GB", "100 GB"),
                    listOf("1800*335*", "1800*336*"),
                    listOf("30ថ្ងៃ", "30ថ្ងៃ")
                )
            }
            else -> {
                tableModel = TableModel(
                    "1-Day",
                    listOf("$0.50"),
                    listOf("500 MB"),
                    listOf("1800*331*"),
                    listOf("1 Day")
                )
                tableModel1 = TableModel(
                    "7-Day",
                    listOf("$1"),
                    listOf("10 GB"),
                    listOf("1800*333*"),
                    listOf("7 Days")
                )
                tableModel2 = TableModel(
                    "30-Day",
                    listOf("$5", "$10"),
                    listOf("45 GB", "100 GB"),
                    listOf("1800*335*", "1800*336*"),
                    listOf("30 Days", "30 Days")
                )
            }
        }

        tableDataList.add(tableModel)
        tableDataList.add(tableModel1)
        tableDataList.add(tableModel2)

        return tableDataList
    }

    private fun getInternetPackTitle(language: Int): String {
        return when (language) {
            1 -> "无论您身处何处，都可以享受到最佳 4G 上网体验。对您所需最佳、最优惠的流量包选项说 yes。"
            2 -> "លេងអុីនធឺណិតបានយ៉ាងរីករាយជាមួយបទពិសោធន៍អុីនធឺណិតត 4G ល្អបំផុត\u200B មិនថាអ្នកនៅទីណានៅក្នុងប្រទេសកម្ពុជា។ Say yes ហើយទទួលបាននូវតម្លៃអុីនធឺណិតដែលល្អបំផុតជាមួយកញ្ចប់ដែលមានជា\u200Bច្រើនជម្រើសសម្រាប់អ្នក។"
            else -> "Enjoy surfing the internet with the best 4G xperience no matter where you are in Cambodia. Say yes to the best and affordable Internet Pack options that suit your need. "
        }
    }
    /*
    else if (mIsSeatelAirline) {
            data.add("- Seatel Airline Pack will be automatically renewed.")
            data.add("- To check your pack data, dial 1800*11* or log in to your account via yes app or website.")
            data.add("- If you have used up your Seatel Airline Pack data before the expiry date, you will be charged based on standard charging rates of 0.01\$/10MB from your main balance.")
        } else if (mIsLanmeiAirline) {
            data.add("Lanmei Airline Pack will be automatically renewed.")
            data.add("- To check your pack data, dial 1800*11* or log in to your account via yes app or website.")
            data.add("- If you have used up your Lanmei Airline Pack data before the expiry date, you will be charged based on standard charging rates of 0.01\$/10MB from your main balance.")
        }
     */

    private fun getTermAndService(language: Int): List<String> {
        val data = ArrayList<String>()
        if (mIsValuePack || mIsFortunePack || mIsSeatelAirline || mIsLanmeiAirline) {
            mValuePackModel?.valuePackSecThreeModel?.description?.let { data.add(it) }
        } else {
            when (language) {
                1 -> {
                    data.add("- 您的流量包将自动订阅，除了1天包（10美分）。如果您希望停止使用您的3天，7天或30天的流量包自动更新，请拨打 1800*330*。")
                    data.add("- 查询话费余额，请拨打1800*52*。")
                    data.add("- 如果您在有效期之前用完流量包，您将被按正常的费率收费 1美分/MB。")
                }
                2 -> {
                    data.add("- កញ្ចប់អុីនធឺណិតនឹងត្រូវបានបន្តដោយស្វ័យប្រវត្តិ លើកលែងតែកញ្ចប់អុីនធឺណិត1ថ្ងៃ/10សេន។ បើអ្នកបញ្ឈប់ការភ្ជាប់កញ្ចប់អុីនធឺណិត 3ថ្ងៃ 7ថ្ងៃ ឬ10ថ្ងៃដោយស្វ័យប្រវត្តិ សូមចុច1800*330*។  ")
                    data.add("- ដើម្បីឆែកអុីនធឺណិតដែលនៅសល់ក្នុងគណនី ចុច 1800*52*។ ")
                    data.add("- ប្រសិនបើអ្នកប្រើប្រាស់អុីនធឺណិតអស់ពីកញ្ចប់អុីនធឺណិតរបស់អ្នកមុនថ្ងៃកំណត់ អុីនធឺណិតដែលអ្នកបន្តប្រើប្រាស់នឹងត្រូវគិតតាមអត្រាតម្លៃធម្មតា គឺ1សេន/1MB។")
                }
                else -> {
                    data.add("- Internet Pack will be automatically renewed except 1-Day Package (10 cents). If you wish to cancel auto-renewal for your 3-Day, 7-Day or 30-Day pack, please de-activate by dialing 1800*330*.")
                    data.add("- To check your internet balance, dial 1800*52*.")
                    data.add("- If you have used up your internet quota before the validity period, you will be charged based on Standard Charging Rates at 1 cent for every 1MB.")
                }
            }
        }
        return data
    }

    data class TableModel(
        var dataPack: String = "",
        var fees: List<String> = ArrayList(),
        var datas: List<String> = ArrayList(),
        var activations: List<String> = ArrayList(),
        var validity: List<String> = ArrayList()
    )
}