package com.seatel.mobilehall.util.customview.adapter

import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import androidx.recyclerview.widget.RecyclerView
import com.seatel.mobilehall.R
import com.seatel.mobilehall.util.customview.BottomChooserDialog
import kotlinx.android.synthetic.main.holder_dialog_choose_item.view.*

class BottomChooserAdapter : RecyclerView.Adapter<BottomChooserAdapter.BottomChooserViewHolder>() {
    private var bottomChooserModels = ArrayList<BottomChooserDialog.BottomChooserModel>()
    private var onItemClick: OnItemClick? = null

    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): BottomChooserViewHolder {
        return BottomChooserViewHolder(LayoutInflater.from(parent.context).inflate(R.layout.holder_dialog_choose_item, parent, false))
    }

    override fun getItemCount(): Int {
        return bottomChooserModels.size
    }

    override fun onBindViewHolder(holder: BottomChooserViewHolder, position: Int) {
        holder.itemView.tv_chooser.text = bottomChooserModels[position].name
        holder.itemView.setOnClickListener {
            onItemClick?.onClick(position, bottomChooserModels[position])
        }
    }

    interface OnItemClick {
        fun onClick(position: Int, data: BottomChooserDialog.BottomChooserModel)
    }

    fun addItems(bottomChooserModels: ArrayList<BottomChooserDialog.BottomChooserModel>, onItemClick: OnItemClick) {
        this.onItemClick = onItemClick
        this.bottomChooserModels.clear()
        this.bottomChooserModels.addAll(bottomChooserModels)
    }

    class BottomChooserViewHolder(itemView: View) : RecyclerView.ViewHolder(itemView)
}