package com.seatel.mobilehall.util.customview

import android.animation.ObjectAnimator
import android.content.Context
import android.os.Handler
import android.text.TextUtils
import android.util.AttributeSet
import android.view.LayoutInflater
import android.view.View
import android.view.animation.DecelerateInterpolator
import android.widget.RelativeLayout
import com.seatel.mobilehall.R
import com.seatel.mobilehall.ui.profile.model.BalancesPostPaidModel
import com.seatel.mobilehall.util.Constant
import com.seatel.mobilehall.util.SeatelUtils
import kotlinx.android.synthetic.main.view_list_subscription_postpaid_circle_balances.view.*
import java.text.DecimalFormat

class ListSubscriptionPostPaidCircleBalancesView @JvmOverloads constructor(
    context: Context,
    attrs: AttributeSet? = null,
    defStyleAttr: Int = 0
) : RelativeLayout(context, attrs, defStyleAttr) {

    init {
        LayoutInflater.from(context)
            .inflate(R.layout.view_list_subscription_postpaid_circle_balances, this)
    }

    fun setDataDisplay(data: BalancesPostPaidModel, isTopup: Boolean = false) {
        val decimalFormat = DecimalFormat("#.##")
        ctv_name_balance.text = data.name
        if (isTopup) {
            view_topup_balance_no_circle.visibility = View.VISIBLE
            layout_progress_bar.visibility = View.INVISIBLE
            view_renew_date.visibility = View.GONE
            balance_amount.text = "$${decimalFormat.format(data.balance)}"
            if (data.expiredDate == null || data.expiredDate!!.isEmpty() || TextUtils.equals(
                    data.expiredDate,
                    "null"
                )
            )
                view_expired_date.visibility = View.GONE
            else ctv_date_expired.text = SeatelUtils.getDateTime(
                "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", Constant.DATE_FORMAT_DISPLAY,
                data.expiredDate
            )
            if (data.subscribedDate == null || data.subscribedDate!!.isEmpty() || TextUtils.equals(
                    data.subscribedDate,
                    "null"
                )
            )
                view_subscribe_date.visibility = View.GONE
            else ctv_date_subscribe.text = SeatelUtils.getDateTime(
                "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", Constant.DATE_FORMAT_DISPLAY,
                data.subscribedDate
            )

        } else {
            view_renew_date.visibility = View.VISIBLE
            view_topup_balance_no_circle.visibility = View.INVISIBLE
            layout_progress_bar.visibility = View.VISIBLE
            view_expired_date.visibility = View.GONE
            view_subscribe_date.visibility = View.GONE
            if (data.renewDate == null || data.renewDate!!.isEmpty() || TextUtils.equals(
                    data.renewDate,
                    "null"
                )
            )
                ctv_date_renew.text = "N/A"
            else ctv_date_renew.text = SeatelUtils.getDateTime(
                "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", Constant.DATE_FORMAT_DISPLAY,
                data.renewDate
            )

            view_progress_bar.dataLeftText = SeatelUtils.translatForDialog(
                context,
                context.getString(R.string.remaining_balance)
            )
            view_progress_bar.max = data.totalBalance!!.toFloat()
            view_progress_bar.isShowDollar = true
            view_progress_bar.textSize = 80f
            //    view_progress_bar.isShowdollarInSubscription = true

            var remainProgress = data.remainingBalance!!.toFloat()
            var duration: Long = 1500
            if (remainProgress == view_progress_bar.max)
                duration = 800
            val finalDuration = duration
            val finalRemainProgress = remainProgress
            val delay = Handler()
            delay.postDelayed(object : Runnable {
                override fun run() {
                    val progressAnimator = ObjectAnimator.ofFloat(
                        view_progress_bar,
                        "progress",
                        0f,
                        finalRemainProgress
                    )
                    progressAnimator.duration = finalDuration
                    progressAnimator.interpolator = DecelerateInterpolator()
                    progressAnimator.start()
                    delay.removeCallbacks(this)
                }
            }, 1000)
        }
    }

}