package com.seatel.mobilehall.ui.packages.adapter

import android.content.Context
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import androidx.core.content.ContextCompat
import androidx.recyclerview.widget.RecyclerView
import com.seatel.mobilehall.R
import com.seatel.mobilehall.databinding.ItemLayoutLoyKobTabBinding
import com.seatel.mobilehall.databinding.ItemLayoutLoyKobTitleBinding
import com.seatel.mobilehall.ui.base.adapter.BaseAdapter
import com.seatel.mobilehall.ui.home.activity.ConfirmBuyDataPackActivity
import com.seatel.mobilehall.ui.home.adapter.TermAndServiceFooter2Adapter
import com.seatel.mobilehall.ui.home.model.ValuePackSectionModel
import com.seatel.mobilehall.util.Constant
import kotlinx.android.synthetic.main.item_layout_loy_kob_tab.view.baseValidity
import kotlinx.android.synthetic.main.item_layout_loy_kob_tab.view.btn_addon
import kotlinx.android.synthetic.main.item_layout_loy_kob_tab.view.btn_data
import kotlinx.android.synthetic.main.item_layout_loy_kob_tab.view.btn_package
import kotlinx.android.synthetic.main.item_layout_loy_kob_tab.view.btn_plan
import kotlinx.android.synthetic.main.item_layout_loy_kob_tab.view.container_benefit
import kotlinx.android.synthetic.main.item_layout_loy_kob_tab.view.recyclerItemLoyKob
import kotlinx.android.synthetic.main.item_layout_loy_kob_tab.view.recyclerItemLoyKobAddon
import kotlinx.android.synthetic.main.item_layout_loy_kob_tab.view.recyclerTermCondition
import kotlinx.android.synthetic.main.item_layout_loy_kob_title.view.loyKobDescription
import kotlinx.android.synthetic.main.item_layout_loy_kob_title.view.loyKobTitle

class LoyKobsAdapter(
    private var mContext: Context,
    private var type: String,
    private var canSubscribe: Boolean,
    private var appProductsDetail: ValuePackSectionModel
) : BaseAdapter<RecyclerView.ViewHolder>() {

    companion object {
        private const val HEADER_TITLE = 0
        private const val HEADER_TAB = 1
    }

    private var selectedButton = 1

    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): RecyclerView.ViewHolder {
        return when (viewType) {
            HEADER_TITLE -> {
                val binding = ItemLayoutLoyKobTitleBinding.inflate(
                    LayoutInflater.from(parent.context), parent, false
                )
                HeaderTitleHolder(binding)
            }

            else -> {
                val binding = ItemLayoutLoyKobTabBinding.inflate(
                    LayoutInflater.from(parent.context), parent, false
                )
                HeaderTabHolder(binding)
            }

            /*else -> {
                val binding = ItemLayoutLoyKobDataBinding.inflate(
                    LayoutInflater.from(parent.context), parent, false
                )
                DataHolder(binding)
            }*/
        }
    }

    override fun getItemCount(): Int {
        return 2
    }

    override fun getItemViewType(position: Int): Int {
        return position
    }

    override fun onBindViewHolder(holder: RecyclerView.ViewHolder, position: Int) {


        when (holder.itemViewType) {
            HEADER_TITLE -> {
                holder.itemView.loyKobTitle.text = appProductsDetail.valuePackSecTwoModel.title
                holder.itemView.loyKobDescription.text =
                    appProductsDetail.valuePackSecTwoModel.subTitle

            }

            HEADER_TAB -> {
                when (type) {
                    Constant.LoyKob -> {
                        holder.itemView.btn_data.text = "Benefit offer"
                    }

                    else -> holder.itemView.btn_data.text = "Data"
                }
                updateTabLayout(holder)
                holder.itemView.btn_plan.setOnClickListener {
                    selectedButton = 1
                    updateTabLayout(holder)
                    holder.itemView.container_benefit.visibility = View.VISIBLE
                    holder.itemView.recyclerTermCondition.visibility = View.GONE
                }

                holder.itemView.btn_package.setOnClickListener {
                    selectedButton = 2
                    updateTabLayout(holder)
                    holder.itemView.container_benefit.visibility = View.GONE
                    holder.itemView.recyclerTermCondition.visibility = View.VISIBLE
                    holder.itemView.recyclerTermCondition.adapter = TermAndServiceFooter2Adapter(
                        mContext, appProductsDetail, true
                    )
                }

                holder.itemView.recyclerItemLoyKob.adapter = LoyKobListAdapter(
                    appProductsDetail.valuePackSecTwoModel.table, "Table", type, canSubscribe
                ) {
                    ConfirmBuyDataPackActivity.launch(
                        mContext,
                        appProductsDetail.name,
                        appProductsDetail.type,
                        it.validityDate,
                        it.valuePrice,
                        it.priceChange,
                        it.code,
                        false
                    )
                }

                holder.itemView.recyclerItemLoyKobAddon.adapter = LoyKobListAdapter(
                    appProductsDetail.valuePackSecTwoModel.addon, "Addon", type, canSubscribe
                ) {
                    ConfirmBuyDataPackActivity.launch(
                        mContext,
                        appProductsDetail.name,
                        appProductsDetail.type,
                        it.validityDate,
                        it.valuePrice,
                        it.priceChange,
                        it.code,
                        true
                    ) 
                }

                if (appProductsDetail.valuePackSecTwoModel.addon.size > 0) {
                    holder.itemView.btn_addon.visibility = View.VISIBLE
                    if (type == Constant.LoyKob) {
                        holder.itemView.baseValidity.text =
                            appProductsDetail.valuePackSecTwoModel.addon[0].validityDate
                    }
                }
            }

        }
    }

    class HeaderTitleHolder(var itemView: ItemLayoutLoyKobTitleBinding) :
        RecyclerView.ViewHolder(itemView.root)

    class HeaderTabHolder(var itemView: ItemLayoutLoyKobTabBinding) :
        RecyclerView.ViewHolder(itemView.root)

    /* class DataHolder(var itemView: ItemLayoutLoyKobDataBinding) :
         RecyclerView.ViewHolder(itemView.root)*/


    private fun updateTabLayout(holder: RecyclerView.ViewHolder) {

        val defaultColor = ContextCompat.getColor(mContext, R.color.white)
        val selectedColor = ContextCompat.getDrawable(mContext, R.drawable.bg_button_round_service)

        holder.itemView.btn_plan.setBackgroundColor(defaultColor)
        holder.itemView.btn_plan.setTextColor(
            ContextCompat.getColor(
                mContext, R.color.black
            )
        )
        holder.itemView.btn_package.setBackgroundColor(defaultColor)
        holder.itemView.btn_package.setTextColor(
            ContextCompat.getColor(
                mContext, R.color.black
            )
        )

        when (selectedButton) {
            1 -> {
                holder.itemView.btn_plan.setBackgroundDrawable(selectedColor)
                holder.itemView.btn_plan.setTextColor(
                    ContextCompat.getColor(
                        mContext, R.color.white
                    )
                )
            }

            2 -> {
                holder.itemView.btn_package.setBackgroundDrawable(selectedColor)
                holder.itemView.btn_package.setTextColor(
                    ContextCompat.getColor(
                        mContext, R.color.white
                    )
                )
            }
        }


    }


}