package com.seatel.mobilehall.ui.packages.adapter

import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import androidx.recyclerview.widget.RecyclerView
import com.seatel.mobilehall.databinding.ItemLoyKobListBinding
import com.seatel.mobilehall.ui.base.adapter.BaseAdapter
import com.seatel.mobilehall.ui.home.model.ValuePackTableModel
import com.seatel.mobilehall.util.Constant
import kotlinx.android.synthetic.main.item_loy_kob_list.view.btnActivation
import kotlinx.android.synthetic.main.item_loy_kob_list.view.btnBenefit
import kotlinx.android.synthetic.main.item_loy_kob_list.view.btnFee
import kotlinx.android.synthetic.main.item_loy_kob_list.view.btnValidity
import kotlinx.android.synthetic.main.item_loy_kob_list.view.btn_click

class LoyKobListAdapter(
    private val tableList: List<ValuePackTableModel>,
    private var type: String,
    private var isData: String,
    private var canSubscribe: Boolean,
    private val rowClick: (ValuePackTableModel) -> Unit
) : BaseAdapter<LoyKobListAdapter.ViewHolder>() {


    class ViewHolder(var itemView: ItemLoyKobListBinding) : RecyclerView.ViewHolder(itemView.root)

    override fun onCreateViewHolder(
        parent: ViewGroup, viewType: Int
    ): ViewHolder {
        val binding = ItemLoyKobListBinding.inflate(
            LayoutInflater.from(parent.context), parent, false
        )
        return ViewHolder(binding)
    }

    override fun onBindViewHolder(holder: ViewHolder, position: Int) {

        when (type) {

            "Table" -> {
                when (isData) {
                    Constant.LoyKob -> {
                        holder.itemView.btnFee.text = tableList[position].valuePrice
                        holder.itemView.btnBenefit.text = tableList[position].benefitOffer
                        holder.itemView.btnValidity.text = tableList[position].validityDate
                        holder.itemView.btnActivation.text = tableList[position].activation
                    }

                    else -> {
                        holder.itemView.btnFee.text = tableList[position].valuePrice
                        holder.itemView.btnBenefit.text = tableList[position].priceChange
                        holder.itemView.btnValidity.text = tableList[position].validityDate
                        holder.itemView.btnActivation.text = tableList[position].activation
                    }
                }
                holder.itemView.run {
                    if (canSubscribe) btn_click.visibility =
                        View.VISIBLE else btn_click.visibility = View.GONE

                    btn_click.setOnClickListener {
                        val data = tableList[position]
                        rowClick.invoke(data)

                    }
                }


            }

            "Addon" -> {

                holder.itemView.run {
                    var callSmsData = ""
                    tableList[position].callsmsList.forEach {
                        callSmsData = it
                    }

                    btnFee.text = tableList[position].valuePrice
                    btnBenefit.text = tableList[position].priceChange + callSmsData
                    btnActivation.text = tableList[position].activation

                    if (tableList[position].activateBtn) btn_click.visibility =
                        View.VISIBLE else btn_click.visibility = View.GONE

                    btn_click.setOnClickListener {
                        val data = tableList[position]
                        rowClick.invoke(data)
                    }
                }

            }

        }


    }

    override fun getItemCount(): Int {
        return tableList.size
    }
}