package com.seatel.mobilehall.ui.lang.adapter

import android.content.Context
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import androidx.recyclerview.widget.RecyclerView
import com.seatel.mobilehall.R
import com.seatel.mobilehall.data.prefs.LanguagePreference
import com.seatel.mobilehall.ui.base.adapter.BaseAdapter
import com.seatel.mobilehall.ui.lang.interactor.SettingLanguageInteractor
import com.seatel.mobilehall.ui.lang.model.LanguageModel
import com.seatel.mobilehall.util.customview.CustomButton
import com.seatel.mobilehall.util.lang.FirstLoginPreference
import com.google.gson.Gson
import com.google.gson.reflect.TypeToken
import kotlinx.android.synthetic.main.item_language_select.view.*

class LanguageAdapter(mContext: Context, mSettingLanguageInteractor: SettingLanguageInteractor?) :
    BaseAdapter<LanguageAdapter.LanguageViewHolder>() {

    private var mContext: Context? = null
    val json = LanguagePreference.getInstance(mContext)?.getAppSharedLanguagePreference()
    val type = object : TypeToken<List<LanguageModel>>() {
    }.type
    private var mLanguageModel: List<LanguageModel> = Gson().fromJson(json, type)
    private var mSettingLanguageInteractor: SettingLanguageInteractor? = null

    init {
        this.mContext = mContext
        this.mSettingLanguageInteractor = mSettingLanguageInteractor
    }

    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): LanguageViewHolder {
        return LanguageViewHolder(
            LayoutInflater.from(mContext).inflate(R.layout.item_language_select, parent, false)
        )
    }

    override fun getItemCount(): Int {
        return mLanguageModel.size
    }

    override fun onBindViewHolder(holder: LanguageViewHolder, position: Int) {
        if (getLastPosition() == -1) {
            holder.itemView.visibility = View.INVISIBLE
        }
        setAnimations(holder.itemView, position)

        val languageModel = mLanguageModel[position]
        holder.titleBtn.noTranslate = true
        holder.titleBtn.text = languageModel.languageName
        holder.titleBtn.setOnClickListener {
            if (mSettingLanguageInteractor != null) {
                mSettingLanguageInteractor?.onItemLanguageDataClick(languageModel)
            }
            if (mContext != null)
                FirstLoginPreference.getInstance(mContext!!)!!.setFirstLoginPreference(true)
        }
    }

    class LanguageViewHolder(itemView: View) : RecyclerView.ViewHolder(itemView) {
        var titleBtn = itemView.btn_language as CustomButton
    }

}