package com.seatel.mobilehall.ui.home.fragment


import android.content.Context
import android.os.Bundle
import android.view.View
import androidx.recyclerview.widget.GridLayoutManager
import com.seatel.mobilehall.R
import com.seatel.mobilehall.ui.base.fragment.BaseFragment
import com.seatel.mobilehall.ui.home.adapter.PrefixNumberAdapter
import kotlinx.android.synthetic.main.fragment_pro_number_one.*


class PrefixNumberOneFragment : BaseFragment() {
    private lateinit var prefixNumberAdapter: PrefixNumberAdapter
    private val prefixNumberModel: ArrayList<PrefixNumberAdapter.PrefixNumberModel> = ArrayList()
    var click: PrefixNumberAdapter.Click? = null

    override fun onAttach(context: Context) {
        super.onAttach(context)
        setmContext(context)
        setFragmentLayout(R.layout.fragment_pro_number_one)
    }


    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        super.onViewCreated(view, savedInstanceState)
        recycler_view_prefix_number.layoutManager = GridLayoutManager(activity, 2)
        prefixNumberAdapter = PrefixNumberAdapter(requireContext(), prefixNumberModel)
        prefixNumberAdapter.click = PrefixNumberAdapter.Click { number -> click?.onClick(number) }
        recycler_view_prefix_number.adapter = prefixNumberAdapter
        recycler_view_prefix_number.setHasFixedSize(true)
        init()
    }

    private fun init() {
        prefixNumberModel.add(PrefixNumberAdapter.PrefixNumberModel("0183"))
        prefixNumberModel.add(PrefixNumberAdapter.PrefixNumberModel("0184"))
        prefixNumberModel.add(PrefixNumberAdapter.PrefixNumberModel("0185"))
        prefixNumberModel.add(PrefixNumberAdapter.PrefixNumberModel("0186"))
        prefixNumberModel.add(PrefixNumberAdapter.PrefixNumberModel("0187"))
        prefixNumberModel.add(PrefixNumberAdapter.PrefixNumberModel("0188"))
        prefixNumberModel.add(PrefixNumberAdapter.PrefixNumberModel("0189"))
    }
}
