package com.seatel.mobilehall.ui.packages.adapter

import android.view.LayoutInflater
import android.view.ViewGroup
import androidx.recyclerview.widget.RecyclerView
import coil.load
import com.seatel.mobilehall.databinding.LayoutRikReayBinding
import com.seatel.mobilehall.ui.base.adapter.BaseAdapter
import com.seatel.mobilehall.ui.packages.model.RikReayModel
import kotlinx.android.synthetic.main.layout_rik_reay.view.iv_header_banner
import kotlinx.android.synthetic.main.layout_rik_reay.view.iv_sub_header
import kotlinx.android.synthetic.main.layout_rik_reay.view.last_sub_title
import kotlinx.android.synthetic.main.layout_rik_reay.view.last_title
import kotlinx.android.synthetic.main.layout_rik_reay.view.mRecyclerTable
import kotlinx.android.synthetic.main.layout_rik_reay.view.mWebView
import kotlinx.android.synthetic.main.layout_rik_reay.view.tv_content_title
import kotlinx.android.synthetic.main.layout_rik_reay.view.tv_header_description
import kotlinx.android.synthetic.main.layout_rik_reay.view.tv_header_subTitle
import kotlinx.android.synthetic.main.layout_rik_reay.view.tv_header_title
import kotlinx.android.synthetic.main.layout_rik_reay.view.tv_sub_header_subTitle
import kotlinx.android.synthetic.main.layout_rik_reay.view.tv_table_title

class RikReayAdapter(private var rikReayModel: RikReayModel) :
    BaseAdapter<RikReayAdapter.ViewHolder>() {


    class ViewHolder(var itemView: LayoutRikReayBinding) : RecyclerView.ViewHolder(itemView.root)

    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): RikReayAdapter.ViewHolder {
        val binding = LayoutRikReayBinding.inflate(
            LayoutInflater.from(parent.context), parent, false
        )

        return ViewHolder(binding)
    }

    override fun onBindViewHolder(holder: RikReayAdapter.ViewHolder, position: Int) {
        holder.itemView.run {
            iv_header_banner.load(rikReayModel.backgroundImg) {
                crossfade(true)

            }

            tv_header_title.text = rikReayModel.mainTitle
            tv_header_subTitle.text = rikReayModel.mainContent[0].title

            tv_header_description.settings.javaScriptEnabled = true
            tv_header_description.loadDataWithBaseURL(
                null, rikReayModel.mainContent[0].content, "text/html", "UTF-8", null
            )
            tv_header_description.settings.defaultFontSize = 12

            iv_sub_header.load(rikReayModel.mainContent[1].imgurl) {
                crossfade(true)
            }

            tv_sub_header_subTitle.settings.javaScriptEnabled = true
            tv_sub_header_subTitle.loadDataWithBaseURL(
                null, rikReayModel.mainContent[1].content, "text/html", "UTF-8", null
            )
            tv_sub_header_subTitle.settings.defaultFontSize = 12

            tv_content_title.text = rikReayModel.mainContent[2].title

            val htmString = rikReayModel.mainContent[2].content
            mWebView.settings.javaScriptEnabled = true
            mWebView.loadDataWithBaseURL(null, htmString, "text/html", "UTF-8", null)
            mWebView.settings.defaultFontSize = 12

            tv_table_title.text = rikReayModel.mainContent[2].tableTitle
            mRecyclerTable.adapter = RikReakDetailAdapter(context, rikReayModel)
            last_title.text = rikReayModel.mainContent[3].title

            last_sub_title.settings.javaScriptEnabled = true
            last_sub_title.loadDataWithBaseURL(
                null, rikReayModel.mainContent[3].content, "text/html", "UTF-8", null
            )
            last_sub_title.settings.defaultFontSize = 12
        }
    }

    override fun getItemCount(): Int {
        return 1
    }

    override fun getItemViewType(position: Int): Int {
        return position
    }
}