package com.seatel.mobilehall.ui.mysterybox

import android.content.Context
import android.content.Intent
import android.os.Bundle
import android.view.View
import androidx.recyclerview.widget.LinearLayoutManager
import com.android.volley.Request
import com.android.volley.VolleyError
import com.seatel.mobilehall.R
import com.seatel.mobilehall.data.network.SeatelJSONObjectRequest
import com.seatel.mobilehall.data.network.SeatelSuperRequest
import com.seatel.mobilehall.ui.base.activity.BaseActivity
import com.seatel.mobilehall.util.CustomGameDialog
import com.seatel.mobilehall.util.customview.ErrorHandleView
import kotlinx.android.synthetic.main.valentine_reward_layout.*
import org.json.JSONObject

class ValentineRewardActivity : BaseActivity(), ValentineInteractor.View {

    companion object {
        fun launch(context: Context) {
            val intent = Intent(context, ValentineRewardActivity::class.java)
            context.startActivity(intent)
        }
    }

    private var firstOpen = false


    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.valentine_reward_layout)
        error_view.setViewMode(ErrorHandleView.Mode.LOADING)
        firstOpen = true
        ValentinePresenter(this, this).getValentineReward("${getPhoneLogin()}")
    }

    override fun onValentineRewardSucceed(angPaoListItem: ArrayList<MysteryBoxModelItem>) {
        firstOpen = false
        valentine_recycler.apply {
            layoutManager =
                LinearLayoutManager(
                    this@ValentineRewardActivity,
                    LinearLayoutManager.VERTICAL,
                    false
                )
            adapter = ValentineRewardAdapter(this@ValentineRewardActivity, angPaoListItem) {
                claimPrize(it._id, it.usefor)
                error_view.visibility = View.VISIBLE
            }
        }

        error_view.visibility = View.GONE
    }


    private fun claimPrize(id: String, type: String) {
        object : SeatelJSONObjectRequest(this) {
            override fun getFunctionName(): String {
                return "v2/seatel/claim-prize/$id/mystery-box"
            }

            override fun getMethod(): Int {
                return Request.Method.PUT
            }

        }.setOnErrorListener {
            /*SeatelAlertDialog.with(this, SeatelSuperRequest.getErrorMessageFrom(it))
                .show()*/
            val valentineDialog =
                CustomGameDialog(this, SeatelSuperRequest.getErrorMessageFrom(it), "", "", "", true)
            valentineDialog.show()
            error_view.visibility = View.GONE
        }.execute {
            val mTitile = (it as JSONObject).optString("title")
            val mPrize = it.optString("prize")
            val image = it.optString("image")
            val subtitle = it.optString("subtitle")
            // showDialog(this, mTitile, mPrize, type)
            val valentineDialog = CustomGameDialog(this, mTitile, mPrize, subtitle, image, true)
            valentineDialog.show()
            valentineDialog.setOnDismissListener {
                onResume()
            }

            error_view.visibility = View.GONE
        }
    }


    override fun onValentineRewardFailed(error: VolleyError) {
        firstOpen = false
        val valentineDialog =
            CustomGameDialog(this, SeatelSuperRequest.getErrorMessageFrom(error), "", "", "", true)
        valentineDialog.show()
        error_view.visibility = View.GONE
    }


    override fun onResume() {
        super.onResume()
        if (!firstOpen)
            ValentinePresenter(this, this).getValentineReward("${getPhoneLogin()}")
    }


    override fun getToolbarTitle(): String {
        return resources.getString(R.string.claim)
    }


}