package com.seatel.mobilehall.ui.home.viewholder

import android.view.View
import com.seatel.mobilehall.ui.base.adapter.BaseRecyclerAdapter
import com.seatel.mobilehall.ui.home.model.SimCardPriceModel
import com.seatel.mobilehall.util.SeatelUtils
import kotlinx.android.synthetic.main.layout_start_end_price_item.view.*

/**
 *
 *
 * @author Noel
 * @version
 * @created on 19-Oct-18
 */
class SimPriceViewHolder(itemView: View) : BaseViewHolder<SimCardPriceModel>(itemView) {
    override fun binData(baseRecyclerAdapter: BaseRecyclerAdapter<SimCardPriceModel>) {
        val data = baseRecyclerAdapter.getItem(adapterPosition)
//        val rangShow = AppUtils.getTitle(data)
        itemView.text_title_last.visibility = View.GONE
        itemView.text_title_first.visibility = View.GONE
        itemView.text_title.visibility = View.GONE
        itemView.tv_center_sign.visibility = View.GONE
        if (data.startPrice != data.endPrice) { //rangShow.second.isEmpty()
            itemView.text_title.visibility = View.VISIBLE
            itemView.text_title.text = SeatelUtils.translatForDialog(
                itemView.context,
                data.name
            ) //AppUtils.getTitle(data).first
        } else {
            itemView.text_title_last.visibility = View.VISIBLE
            itemView.text_title_first.visibility = View.VISIBLE
            itemView.tv_center_sign.visibility = View.VISIBLE
            itemView.text_title_last.text = "$${data.startPrice}" //AppUtils.getTitle(data).second
            itemView.text_title_first.text = data.name//AppUtils.getTitle(data).first
        }
    }
}