package com.seatel.mobilehall.ui.home.activity

import android.content.Context
import android.content.Intent
import android.graphics.Typeface
import android.os.Bundle
import android.view.ViewGroup
import android.widget.TextView
import androidx.core.content.ContextCompat
import com.google.android.material.tabs.TabLayout
import com.seatel.mobilehall.R
import com.seatel.mobilehall.ui.base.activity.BaseActivity
import com.seatel.mobilehall.ui.base.fragment.BaseFragment
import com.seatel.mobilehall.ui.home.adapter.TopUpPagerAdapter
import com.seatel.mobilehall.ui.home.fragment.PinFragment
import com.seatel.mobilehall.ui.home.fragment.PinlessFragment
import com.seatel.mobilehall.util.FontCache
import kotlinx.android.synthetic.main.activity_top_up.*

class TopUpActivity : BaseActivity() {

    private lateinit var mTopUpViewpagerAdapter: TopUpPagerAdapter

    // private var mGuideView: GuideView? = null
    // private var mTopupGuideShow: GuideView.Builder? = null
    private var mPinLessFragment: PinlessFragment? = null
    private var mPinFragment: PinFragment? = null

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.activity_top_up)
        super.activityEnterRightAnimation()
        init()

    }

    override fun getToolbarTitle(): String {
        return resources.getString(R.string.top_up_balance)
    }

    override fun onBackPressed() {

        val baseFragment: BaseFragment =
            mTopUpViewpagerAdapter.getCurrentFragment()!!

        if (baseFragment.isKeyboardHided()) {
            super.onBackPressed()
            super.activityExitLeftAnimation()
        } else baseFragment.hideKeyBoard()
    }

    private fun init() {
        tab_layout_top_up.setupWithViewPager(viewpager_top_up)
        title_top_up.text = getString(R.string.pinless)
        val strPinless = title_top_up.text

        title_top_up.text = getString(R.string.pin)
        val strPin = title_top_up.text

        mTopUpViewpagerAdapter = TopUpPagerAdapter(supportFragmentManager)
        mPinLessFragment = PinlessFragment()
        mPinLessFragment?.setPhoneNuber(getPhoneLogin())
        mPinFragment = PinFragment()
        mPinFragment?.setPhoneNuber(getPhoneLogin())

        mTopUpViewpagerAdapter.addFragment(mPinLessFragment!!, strPinless as String)
        mTopUpViewpagerAdapter.addFragment(mPinFragment!!, strPin as String)
        viewpager_top_up.adapter = mTopUpViewpagerAdapter
        viewpager_top_up.offscreenPageLimit = 2
        setTabTextStyle()

        //Test App Guide
        /*  if (Constant.SHOW_TEST_APP_GUIDE) {
              LanguagePreference.getInstance(this)?.setAppGuideTopupPin(false)
              LanguagePreference.getInstance(this)?.setAppGuideTopupPinLess(false)
          }

          if (Constant.OFF_APP_GUIDE)
              showAppGuide()*/
    }

    private fun showAppGuide() {
        //  val mAppGuideSetting = LanguagePreference.getInstance(this)?.getAppGuideTopupPinLess()
        /*if (mAppGuideSetting != null)
            if (!mAppGuideSetting) {
                mTopupGuideShow = GuideView.Builder(this)
                    .setTitle(SeatelUtils.translatForDialog(this@TopUpActivity, getString(R.string.topup_via_online_payment)))
                    .setGravity(Gravity.center)
                    .setDismissType(DismissType.outside)
                    .setTargetView(tab_layout_top_up.getTabAt(0)?.customView)
                    .setGuideListener {
                        when {
                            it.id == R.id.view_phone_number -> {
                                mTopupGuideShow?.setTargetView(mPinLessFragment?.getViewAmount())
                                    ?.setTitle(SeatelUtils.translatForDialog(this@TopUpActivity, getString(R.string.message_app_guide_input_amount)))
                                    ?.build()
                            }
                            it.id == R.id.view_amount -> {
                                mTopupGuideShow?.setTargetView(mPinLessFragment?.getViewButton())
                                    ?.setTitle(SeatelUtils.translatForDialog(this@TopUpActivity, getString(R.string.message_app_guide_continue)))
                                    ?.build()
                            }
                            it.id == R.id.button_next -> {
                                return@setGuideListener
                            }
                            else -> {
                                mTopupGuideShow?.setTargetView(mPinLessFragment?.getViewPhoneNumber())
                                    ?.setTitle(SeatelUtils.translatForDialog(this@TopUpActivity, getString(R.string.input_number_app_guide_pinless)))
                                    ?.build()
                            }
                        }
                        mGuideView = mTopupGuideShow?.build()
                        mGuideView?.updateGuideViewLocation()
                        mGuideView?.show()
                    }
                mGuideView = mTopupGuideShow?.build()
                mGuideView?.updateGuideViewLocation()
                mGuideView?.show()
                LanguagePreference.getInstance(this)?.setAppGuideTopupPinLess(true)
            }*/
    }

    private fun showAppGuidePin() {
        //  val mAppGuideSetting = LanguagePreference.getInstance(this)?.getAppGuideTopupPin()
        /* if (mAppGuideSetting != null)
             if (!mAppGuideSetting) {
                 mTopupGuideShow?.setTargetView(tab_layout_top_up.getTabAt(1)?.customView)
                     ?.setTitle(SeatelUtils.translatForDialog(this@TopUpActivity, getString(R.string.topup_via_scratch_card)))
                     ?.setGuideListener {
                         when {
                             it.id == R.id.view_phone_number -> {
                                 mTopupGuideShow?.setTargetView(mPinFragment?.getViewAmount())
                                     ?.setTitle(SeatelUtils.translatForDialog(this@TopUpActivity, getString(R.string.message_app_guide_scratch_card_pin)))
                             }
                             it.id == R.id.view_amount -> {
                                 return@setGuideListener
                             }
                             it.id == R.id.tab2 -> {
                                 it.id = R.id.tab2New
                             }
                             it.id == R.id.tab2New -> {
                                 mTopupGuideShow?.setTargetView(mPinFragment?.getViewPhoneNumber())
                                     ?.setTitle(SeatelUtils.translatForDialog(this@TopUpActivity, getString(R.string.input_number_app_guide_pinless)))
                             }
                         }
                         mGuideView = mTopupGuideShow?.build()
                         mGuideView?.updateGuideViewLocation()
                         mGuideView?.show()
                     }
                 mGuideView = mTopupGuideShow?.build()
                 mGuideView?.updateGuideViewLocation()
                 mGuideView?.show()
                 LanguagePreference.getInstance(this)?.setAppGuideTopupPin(true)
             }*/
        hidePinGuide()
    }

    private fun hidePinGuide() {
        /* if (Constant.OFF_APP_GUIDE) {
             mGuideView?.dismiss()
         }*/
    }

    override fun onPause() {
        super.onPause()
        /* if (Constant.OFF_APP_GUIDE) {
             hidePinGuide()
         }*/
    }

    private fun setTabTextStyle() {

        val font = FontCache.getFont(this@TopUpActivity, Typeface.NORMAL)
        val tf = FontCache.get(this@TopUpActivity, font)

        for (i in 0 until tab_layout_top_up.tabCount) {
            val tab = tab_layout_top_up.getTabAt(i)

            if (tab != null) {
                val tabTextView = TextView(this)
                tab.customView = tabTextView
                tabTextView.layoutParams.width = ViewGroup.LayoutParams.WRAP_CONTENT
                tabTextView.layoutParams.height = ViewGroup.LayoutParams.WRAP_CONTENT
                tabTextView.text = tab.text
                tabTextView.textSize = 16F
                tabTextView.id = if (i == 0) R.id.tab1 else R.id.tab2
                tabTextView.setTypeface(tf, Typeface.NORMAL)

                tabTextView.setTextColor(ContextCompat.getColor(this, android.R.color.white))
                // First tab is the selected tab, so if i==0 then set BOLD typeface
                if (i == 0) {
                    val fontBold = FontCache.getFont(this@TopUpActivity, Typeface.BOLD)
                    val bold = FontCache.get(this@TopUpActivity, fontBold)
                    tabTextView.setTypeface(bold, Typeface.BOLD)
                }
            }
        }
        tab_layout_top_up.addOnTabSelectedListener(object : TabLayout.OnTabSelectedListener {

            override fun onTabSelected(tab: TabLayout.Tab) {
                viewpager_top_up.currentItem = tab.position
                val text = tab.customView as TextView?
                val font = FontCache.getFont(this@TopUpActivity, Typeface.BOLD)
                text!!.setTypeface(FontCache[this@TopUpActivity, font], Typeface.BOLD)
                /*  if (Constant.OFF_APP_GUIDE) {
                      if (tab.position == 1) {
                          Handler().postDelayed({
                              showAppGuidePin()
                          }, 300)
                      } else if (tab.position == 0) {
                          hidePinGuide()
                      }
                  }*/
            }

            override fun onTabUnselected(tab: TabLayout.Tab) {
                val text = tab.customView as TextView?
                val font = FontCache.getFont(this@TopUpActivity, Typeface.NORMAL)
                text!!.setTypeface(FontCache[this@TopUpActivity, font], Typeface.NORMAL)
            }

            override fun onTabReselected(tab: TabLayout.Tab) {

            }
        })
    }

    companion object {
        fun lunch(context: Context) {
            val intent = Intent(context, TopUpActivity::class.java)
            context.startActivity(intent)
        }
    }
}
