package com.seatel.mobilehall.ui.home.activity

import android.content.Context
import android.content.Intent
import android.os.Bundle
import android.view.View
import androidx.core.content.ContextCompat
import androidx.recyclerview.widget.LinearLayoutManager
import androidx.recyclerview.widget.RecyclerView
import androidx.swiperefreshlayout.widget.SwipeRefreshLayout
import com.android.volley.NoConnectionError
import com.android.volley.TimeoutError
import com.android.volley.VolleyError
import com.seatel.mobilehall.R
import com.seatel.mobilehall.ui.base.activity.BaseActivity
import com.seatel.mobilehall.ui.profile.adapter.MySubscriptionAdapter
import com.seatel.mobilehall.ui.profile.interactor.MySubScriptionInteractor
import com.seatel.mobilehall.ui.profile.model.MySubscriptionModel
import com.seatel.mobilehall.ui.profile.presenter.MySubscriptionPresenter
import com.seatel.mobilehall.util.customview.ErrorHandleView
import kotlinx.android.synthetic.main.activity_my_subscriptions.*

class MySubscriptionsActivity : BaseActivity(), SwipeRefreshLayout.OnRefreshListener,
    MySubScriptionInteractor.View {

    private var mMySubPresenter: MySubscriptionPresenter? = null
    private var mMySubscriptionModel: MySubscriptionModel? = null
    private var mIsGetData = false

    //private var mGuideView: GuideView? = null
    //  private var mGetMoreAddonGuideShow: GuideView.Builder? = null
    private var layoutManager: RecyclerView.LayoutManager? = null
    private var mAppGuideSetting: Boolean? = false
    private var mAdapter: MySubscriptionAdapter? = null
    private var viewKeepBalanceOnePlan: View? = null
    private var viewKeepExpireOnOnePlan: View? = null
    private var viewKeepExpireOnValuePack: View? = null
    private var viewKeepSubscribeOnValuePack: View? = null
    private var viewKeepAguageValuePack: View? = null
    private var viewKeepArrowListValuePack: View? = null
    private var viewKeepArrowListPostPaid: View? = null

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.activity_my_subscriptions)
        super.activityEnterRightAnimation()
        init()

    }

    override fun getToolbarTitle(): String {
        return resources.getString(R.string.my_subscription)
    }

    private fun init() {
        error_view.setViewMode(ErrorHandleView.Mode.LOADING)
        mMySubPresenter = MySubscriptionPresenter(this, this)
        mMySubPresenter?.onLoadData(getPhoneLogin())

        showProgress()
        swipe_refresh_layout.setOnRefreshListener(this)
        swipe_refresh_layout.setColorSchemeColors(
            ContextCompat.getColor(
                this,
                R.color.colorPrimary
            )
        )
    }

    override fun onRefresh() {
        mMySubPresenter?.onLoadData(getPhoneLogin())
    }

    override fun onLoadDataSucceed(mySubscriptionModel: MySubscriptionModel) {
        error_view.visibility = View.GONE
        if (mySubscriptionModel.subscribedDate.isNullOrEmpty() &&
            mySubscriptionModel.expiredDate.isNullOrEmpty() &&
            mySubscriptionModel.planCode.isNullOrEmpty() &&
            mMySubscriptionModel == null &&
            mySubscriptionModel.dataPlans == null
        ) {

            error_view.setViewMode(ErrorHandleView.Mode.NO_DATA)
        } else {

            mIsGetData = true
            error_view.visibility = View.GONE
            mMySubscriptionModel = mySubscriptionModel
            mAdapter = MySubscriptionAdapter(this, mMySubscriptionModel, isPostPaidAccount())
            recycler_view_my_subscription.adapter = mAdapter
            layoutManager = LinearLayoutManager(this)
            recycler_view_my_subscription.layoutManager = layoutManager

            /* //Test App Guide
             if (Constant.SHOW_TEST_APP_GUIDE) {
                 LanguagePreference.getInstance(this)?.setAppGuideMySubscriptionDetail(!Constant.SHOW_TEST_APP_GUIDE)
                 if (isPostPaidAccount())
                     LanguagePreference.getInstance(this)?.setAppGuideMySubscriptionDetailPostPaidAccount(!Constant.SHOW_TEST_APP_GUIDE)
             }
             if (Constant.OFF_APP_GUIDE)
                 Handler().postDelayed({
                     showAppGuide()
                 }, 1000)*/
        }

        swipe_refresh_layout.isRefreshing = false
        hideProgress()
    }

    /*private fun showAppGuide() {
        mAppGuideSetting = LanguagePreference.getInstance(this)?.getAppGuideMySubscriptionDetail()
        if (isPostPaidAccount())
            mAppGuideSetting = LanguagePreference.getInstance(this)?.getAppGuideMySubscriptionDetailPostPaidAccount()
        if (mAppGuideSetting != null && mAdapter?.itemCount!! > 0 && (mAdapter?.getItemViewType(0) == 0 || mAdapter?.getItemViewType(0) == -1))
            if (!mAppGuideSetting!!) {

                if (mAdapter?.positionValuePackHolder!! > 0) {
                    viewKeepSubscribeOnValuePack = layoutManager?.findViewByPosition(mAdapter?.positionValuePackHolder!!)?.findViewById(R.id.view_keep_data_pack_subscribe_on)
                    viewKeepExpireOnValuePack = layoutManager?.findViewByPosition(mAdapter?.positionValuePackHolder!!)?.findViewById(R.id.view_keep_data_pack_expire_on)
                    viewKeepAguageValuePack = layoutManager?.findViewByPosition(mAdapter?.positionValuePackHolder!!)?.findViewById(R.id.layout_progress_bar)
                    viewKeepArrowListValuePack = layoutManager?.findViewByPosition(mAdapter?.positionValuePackHolder!!)?.findViewById(R.id.view_show_list_data)
                }
                if (mAdapter?.getItemViewType(0) == 0 && !isPostPaidAccount()) {
                    viewKeepBalanceOnePlan = layoutManager?.findViewByPosition(0)?.findViewById(R.id.view_keep_balance)
                    viewKeepExpireOnOnePlan = layoutManager?.findViewByPosition(0)?.findViewById(R.id.view_keep_expire_on)

                    buildAppGuide(layoutManager?.findViewByPosition(0)?.findViewById(R.id.view_keep_subscribe_on), getString(R.string.message_app_guide_subscription_date))

                } else if (mAdapter?.getItemViewType(0) == -1 && isPostPaidAccount()) {
                    viewKeepBalanceOnePlan = layoutManager?.findViewByPosition(0)?.findViewById(R.id.view_keep_bill_date)
                    viewKeepExpireOnOnePlan = layoutManager?.findViewByPosition(0)?.findViewById(R.id.view_keep_payment_date)
                    viewKeepArrowListPostPaid = layoutManager?.findViewByPosition(0)?.findViewById(R.id.view_show_list_data_PostPaid)

                    buildAppGuide(layoutManager?.findViewByPosition(0)?.findViewById(R.id.layout_progress_bar_post_paid), getString(R.string.message_app_guide_unbilled_amount_has_be_paid))
                }

                LanguagePreference.getInstance(this)?.setAppGuideMySubscriptionDetail(true)
                if (isPostPaidAccount())
                    LanguagePreference.getInstance(this)?.setAppGuideMySubscriptionDetailPostPaidAccount(true)
            }
    }*/

    /*private fun buildAppGuide(view: View?, str: String) {
        mGetMoreAddonGuideShow = GuideView.Builder(this)
                .setTitle(SeatelUtils.translatForDialog(this, str))
                .setGravity(Gravity.center)
                .setDismissType(DismissType.outside)
                .setTargetView(view)
                .setGuideListener {
                    when {
                        (it.id == R.id.view_keep_subscribe_on || it.id == R.id.layout_progress_bar_post_paid) && viewKeepBalanceOnePlan != null -> {
                            mGetMoreAddonGuideShow?.setTargetView(viewKeepBalanceOnePlan)
                                    ?.setTitle(SeatelUtils.translatForDialog(this@MySubscriptionsActivity,
                                            if (mAdapter?.getItemViewType(0) == -1) getString(R.string.message_app_guide_bill_date)
                                            else getString(R.string.message_app_guide_balance_left)))
                                    ?.build()
                        }
                        (it.id == R.id.view_keep_balance || it.id == R.id.view_keep_bill_date) && viewKeepExpireOnOnePlan != null -> {
                            mGetMoreAddonGuideShow?.setTargetView(viewKeepExpireOnOnePlan)
                                    ?.setTitle(SeatelUtils.translatForDialog(this@MySubscriptionsActivity,
                                            if (mAdapter?.getItemViewType(0) == -1) getString(R.string.message_app_guide_payment_date)
                                            else getString(R.string.message_app_guide_expiry_date)))
                                    ?.build()
                        }
                        it.id == R.id.view_keep_payment_date && viewKeepArrowListPostPaid != null -> {
                            mGetMoreAddonGuideShow?.setTargetView(viewKeepArrowListPostPaid)
                                    ?.setTitle(SeatelUtils.translatForDialog(this@MySubscriptionsActivity,
                                            getString(R.string.message_app_guide_arrow_list_sub_postpaid)))
                                    ?.build()
                        }
                        it.id == R.id.layout_progress_bar && viewKeepSubscribeOnValuePack != null -> {
                            mGetMoreAddonGuideShow?.setTargetView(viewKeepSubscribeOnValuePack)
                                    ?.setTitle(SeatelUtils.translatForDialog(this@MySubscriptionsActivity,
                                            getString(R.string.message_app_guide_subscription_date)))
                                    ?.build()
                        }
                        it.id == R.id.view_keep_data_pack_subscribe_on && viewKeepExpireOnValuePack != null -> {
                            mGetMoreAddonGuideShow?.setTargetView(viewKeepExpireOnValuePack)
                                    ?.setTitle(SeatelUtils.translatForDialog(this@MySubscriptionsActivity,
                                            getString(R.string.message_app_guide_expiry_date)))
                                    ?.build()
                        }

                        it.id == R.id.view_keep_data_pack_expire_on && viewKeepArrowListValuePack != null -> {
                            mGetMoreAddonGuideShow?.setTargetView(viewKeepArrowListValuePack)
                                    ?.setTitle(SeatelUtils.translatForDialog(this@MySubscriptionsActivity,
                                            getString(R.string.message_app_guide_arrow_list_sub)))
                                    ?.build()
                        }

                        it.id == R.id.view_show_list_data -> {
                            return@setGuideListener
                        }

                        else -> {
                            if (mAdapter?.itemCount!! > 1 && (mAdapter?.positionValuePackHolder!! > 0
                                            || (mAdapter?.getItemViewType(0)!! == -1 && it.id == R.id.view_show_list_data_PostPaid))
                                    && viewKeepAguageValuePack != null) {
                                mGetMoreAddonGuideShow?.setTargetView(viewKeepAguageValuePack)
                                        ?.setTitle(SeatelUtils.translatForDialog(this@MySubscriptionsActivity,
                                                getString(R.string.message_app_guide_amount_left)))
                                        ?.build()
                            } else return@setGuideListener
                        }
                    }

                    mGuideView = mGetMoreAddonGuideShow?.build()
                    mGuideView?.updateGuideViewLocation()
                    mGuideView?.show()
                }
        mGuideView = mGetMoreAddonGuideShow?.build()
        mGuideView?.updateGuideViewLocation()
        mGuideView?.show()
    }*/

    override fun onLoadDataFailed(error: VolleyError) {
        if (!mIsGetData) {

            when (error) {
                is TimeoutError -> {
                    error_view.errorMessage = getString(R.string.connection_timeout)
                    error_view.setViewMode(ErrorHandleView.Mode.TIME_OUT)
                }
                is NoConnectionError -> {
                    error_view.errorMessage = getString(R.string.message_no_internet)
                    error_view.setViewMode(ErrorHandleView.Mode.NO_INTERNET)
                }
                else -> error_view.errorMessage = getString(R.string.no_data)
            }
        }
        hideProgress()
        swipe_refresh_layout.isRefreshing = false
    }

    override fun onDestroy() {
        super.onDestroy()
        mMySubPresenter?.onDestroy()
    }

    override fun onBackPressed() {
        super.onBackPressed()
        super.activityExitLeftAnimation()
    }

    companion object {
        fun lunch(context: Context) {
            val intent = Intent(context, MySubscriptionsActivity::class.java)
            intent.flags = Intent.FLAG_ACTIVITY_CLEAR_TOP
            context.startActivity(intent)
        }
    }
}
