package com.seatel.mobilehall.ui.home.activity

import android.content.Context
import android.content.Intent
import android.os.Bundle
import android.view.View
import androidx.recyclerview.widget.LinearLayoutManager
import com.android.volley.NoConnectionError
import com.android.volley.TimeoutError
import com.android.volley.VolleyError
import com.seatel.mobilehall.R
import com.seatel.mobilehall.data.network.SeatelSuperRequest
import com.seatel.mobilehall.ui.base.activity.BaseActivity
import com.seatel.mobilehall.ui.home.adapter.RelatedQuestionListAdapter
import com.seatel.mobilehall.ui.home.interactor.FAQDetailInteractor
import com.seatel.mobilehall.ui.home.model.FAQModel
import com.seatel.mobilehall.ui.home.presenter.FAQDetailPresenter
import com.seatel.mobilehall.util.Constant
import com.seatel.mobilehall.util.customview.ErrorHandleView
import kotlinx.android.synthetic.main.activity_faq_detail.*

class FaqDetailActivity : BaseActivity(), FAQDetailInteractor.View {


    var presenter: FAQDetailPresenter? = null

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.activity_faq_detail)
        activityEnterRightAnimation()

        presenter = FAQDetailPresenter(this)
        presenter!!.loadData(getQuestionId())
        showProgress()

    }

    override fun responseSucceedFAQDetailData(answer: String) {
        hideProgress()
        txt_question.text = getQuestion()
        txt_answer.text = answer
    }

    override fun responseSucceedGetRelatedQuestion(relatedQuestionList: List<FAQModel>) {

        txt_related.visibility = View.VISIBLE
        rv_related_question.layoutManager = LinearLayoutManager(this)
        rv_related_question.adapter = RelatedQuestionListAdapter(this, relatedQuestionList)
    }

    override fun responseFailedFAQDetail(error: VolleyError) {
        hideProgress()
        error_view.visibility = View.VISIBLE
        when (error) {
            is NoConnectionError -> {
                error_view.errorMessage = getString(R.string.connection_timeout)
                error_view.setViewMode(ErrorHandleView.Mode.NO_INTERNET)
            }
            is TimeoutError -> {
                error_view.errorMessage = getString(R.string.fetch_supported_device_data)
                error_view.setViewMode(ErrorHandleView.Mode.TIME_OUT)
            }
            else -> {
                error_view.errorMessage = SeatelSuperRequest.getErrorMessageFrom(error)
                error_view.setViewMode(ErrorHandleView.Mode.NO_DATA)
            }
        }
    }


    override fun onBackPressed() {
        super.onBackPressed()
        activityExitLeftAnimation()


    }

    fun getQuestion(): String {
        return intent.getStringExtra(Constant.EXTRA_QUESTION).toString()
    }

    fun getQuestionId(): String {
        return intent.getStringExtra(Constant.EXTRA_FAQ_ID).toString()
    }

    override fun isDisplayToolbar(): Boolean {
        return true
    }

    override fun getToolbarTitle(): String {
        return getString(R.string.faqs)
    }

    companion object {
        fun lunch(context: Context, faqId: String, question: String) {
            val intent = Intent(context, FaqDetailActivity::class.java)
            intent.putExtra(Constant.EXTRA_FAQ_ID, faqId)
            intent.putExtra(Constant.EXTRA_QUESTION, question)
            context.startActivity(intent)
        }
    }
}
