package com.seatel.mobilehall.ui.home.adapter

import android.content.Context
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.ImageView
import android.widget.ProgressBar
import android.widget.TextView
import androidx.recyclerview.widget.RecyclerView
import com.seatel.mobilehall.R
import com.seatel.mobilehall.ui.base.adapter.BaseRecyclerAdapter
import com.seatel.mobilehall.ui.home.model.SimCardPricePurchaseAbleModel
import com.seatel.mobilehall.ui.home.model.YesNumberModel
import com.seatel.mobilehall.util.AppUtils
import kotlinx.android.synthetic.main.item_load_more_data.view.*


open class FullNumberAdapter(private val mContext: Context, private val mFullNumberModels: ArrayList<YesNumberModel>) : RecyclerView.Adapter<RecyclerView.ViewHolder>() {
    var isLoadAll = false
    var onItemClickListener: BaseRecyclerAdapter.OnItemClickListener<YesNumberModel>? = null
    var limit = 20
    var mSimPricePurchaseAbleModels = ArrayList<SimCardPricePurchaseAbleModel>()

    companion object {
        const val LOADING_TYPE = 0
        const val ITEM_TYPE = 1
    }

    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): RecyclerView.ViewHolder {
        return if (ITEM_TYPE == viewType) {
            ViewHolder(LayoutInflater.from(mContext).inflate(R.layout.item_yes_number, parent, false))
        } else {
            LoadMoreHolder(LayoutInflater.from(mContext).inflate(R.layout.item_load_more_data, parent, false))
        }
    }

    override fun getItemViewType(position: Int): Int {
        return if (position == mFullNumberModels.size) LOADING_TYPE else ITEM_TYPE
    }

    private fun isPurchaseAble(price: Double): SimCardPricePurchaseAbleModel {
        for (c in mSimPricePurchaseAbleModels) {
            if (c.amount.toDouble() == price && c.amount > 0)
                return c
        }
        val default = SimCardPricePurchaseAbleModel()
        default.isPurchasable = true
        return default
    }

    override fun onBindViewHolder(holder: RecyclerView.ViewHolder, position: Int) {
        if (holder is FullNumberAdapter.ViewHolder) {
            val numberModel = mFullNumberModels[position]
            holder.phoneNumber.text = numberModel.phoneNumber
            if (isPurchaseAble(numberModel.price).isPurchasable) {
                if(numberModel.discountRate > 0.0) {
                    holder.price.text = AppUtils.decimalFormat().format(numberModel.discountedPrice) //numberModel.discountedPrice
                    holder.priceOrigin.text = AppUtils.decimalFormat().format(numberModel.price)
                    holder.viewKeepOriginPrice.visibility = View.VISIBLE //VISIBLE
                }else{
                    holder.price.text = AppUtils.decimalFormat().format(numberModel.price)
                    holder.viewKeepOriginPrice.visibility = View.INVISIBLE
                }
            }else {
                holder.price.text = mContext.getString(R.string.visit_yes_hub)
                holder.viewKeepOriginPrice.visibility = View.INVISIBLE
            }

            holder.checkBox.visibility = if (numberModel.isChecked) View.VISIBLE else View.INVISIBLE
            holder.itemView.setBackgroundResource(if (numberModel.isChecked) R.drawable.bg_buy_sim_item_select else R.drawable.bg_order_search)
            holder.itemView.setOnClickListener {
                onItemClickListener?.onItemClick(holder.itemView, holder.adapterPosition, numberModel)
            }
        } else {
            val loadMoreHolder = holder as LoadMoreHolder
            if (!isLoadAll && mFullNumberModels.size >= limit) {
                loadMoreHolder.progressBar.visibility = View.VISIBLE
            } else {
                loadMoreHolder.progressBar.visibility = View.GONE
            }
        }
    }

    override fun getItemCount(): Int {
        return mFullNumberModels.size + 1
    }

    open class ViewHolder(itemView: View) : RecyclerView.ViewHolder(itemView) {
        val phoneNumber: TextView = itemView.findViewById(R.id.buy_yes_phone_number)
        val price: TextView = itemView.findViewById(R.id.buy_yes_number_price)
        val checkBox: ImageView = itemView.findViewById(R.id.check_box_buy_yes_number)
        val viewKeepOriginPrice: View = itemView.findViewById(R.id.view_keep_origin_price_black)
        val priceOrigin: TextView = itemView.findViewById(R.id.buy_yes_number_price_origin_black)
    }

    class LoadMoreHolder(itemView: View) : RecyclerView.ViewHolder(itemView) {
        var progressBar: ProgressBar = itemView.progressbar
    }
}
