package com.seatel.mobilehall.ui.home.adapter

import android.content.Context
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import androidx.recyclerview.widget.RecyclerView
import com.seatel.mobilehall.R
import com.seatel.mobilehall.ui.base.adapter.BaseAdapter
import com.seatel.mobilehall.ui.home.activity.EShopPhaseTwoActivity
import kotlinx.android.synthetic.main.item_eshop.view.*

class EshopPhaseTwoAdapter(
    private val mContext: Context, private val eShopModels: ArrayList<MenuDataEshop>,
    private val itemEshop: (EShopPhaseTwoActivity.ItemEshop) -> Unit
) : BaseAdapter<EshopPhaseTwoAdapter.EShopViewHolder>() {


    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): EShopViewHolder {
        return EShopViewHolder(
            LayoutInflater.from(mContext).inflate(R.layout.item_eshop, parent, false)
        )
    }

    override fun onBindViewHolder(holder: EShopViewHolder, position: Int) {
        holder.itemView.visibility = View.INVISIBLE
        setAnimations(holder.itemView, position)
        holder.bindView(mContext, eShopModels[position], position, eShopModels.size, itemEshop)
    }

    override fun getItemCount(): Int {
        return eShopModels.size
    }

    class EShopViewHolder(itemView: View) : RecyclerView.ViewHolder(itemView) {
        var mContext: Context? = null
        private val imgResource = itemView.img_eshop
        private val mEshopName = itemView.text_eshop_name
        private val mMainRow = itemView.layout_eshop
        fun bindView(
            context: Context,
            rowData: MenuDataEshop,
            position: Int,
            totalRow: Int,
            rowlistener: (EShopPhaseTwoActivity.ItemEshop) -> Unit
        ) {
            mContext = context
            mEshopName.text = rowData.title

            imgResource.setImageResource(rowData.imgNameRow)
            mMainRow.tag = rowData.Type
            mMainRow.setOnClickListener {
                rowlistener(it.tag as EShopPhaseTwoActivity.ItemEshop)
            }
        }
    }

    data class MenuDataEshop(
        val title: String = "",
        val imgNameRow: Int,
        val Type: EShopPhaseTwoActivity.ItemEshop,
        val messageGuideApp: String = ""
    )
}
