package com.seatel.mobilehall.ui.packages.presenter

import android.content.Context
import com.android.volley.Request
import com.google.gson.Gson
import com.seatel.mobilehall.data.network.SeatelJSONObjectRequest
import com.seatel.mobilehall.ui.packages.interactor.RikReayInteractor
import com.seatel.mobilehall.ui.packages.model.RikReayModel
import com.seatel.mobilehall.util.SeatelUtils
import org.json.JSONObject

class RikReayPresenter(
    private var context: Context, private var rikReayInteractor: RikReayInteractor.View
) : RikReayInteractor.Presenter {


    override fun RikReay() {
        rikReayRequest().setOnErrorListener { error ->
            rikReayInteractor.onRikReayFailed(error)
        }.setOnResponseListener { response ->
            rikReayInteractor.onRikReaySucceed(getRikReayRequest(response as JSONObject))
        }.execute()
    }

    private fun getRikReayRequest(jsonObject: JSONObject): RikReayModel {
        val gson = Gson().fromJson(jsonObject.toString(),RikReayModel::class.java)
        return gson
    }

    private fun rikReayRequest(): SeatelJSONObjectRequest {
        return object : SeatelJSONObjectRequest(context) {
            override fun getFunctionName(): String {
                return "v2/products/plan-page/rik-reay?lang=${SeatelUtils.getLangaugeCode(context)}"
            }


            override fun getMethod(): Int {
                return Request.Method.GET
            }
        }
    }
}