package com.seatel.mobilehall.ui.packages.adapter

import android.content.Context
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.TextView
import androidx.recyclerview.widget.RecyclerView
import com.seatel.mobilehall.R
import com.seatel.mobilehall.ui.base.adapter.BaseAdapter
import com.seatel.mobilehall.ui.packages.model.RikReayModel
import com.seatel.mobilehall.util.customview.CustomTextView

class RikReakDetailAdapter(
    private val mContext: Context, private val rikReayModel: RikReayModel
) : BaseAdapter<RikReakDetailAdapter.ViewHolder>() {

    class ViewHolder(itemView: View) : RecyclerView.ViewHolder(itemView) {
        val leftItem = itemView.findViewById<CustomTextView>(R.id.tv_table_left)
        val rightItem = itemView.findViewById<CustomTextView>(R.id.tv_table_right)
    }


    override fun onCreateViewHolder(
        parent: ViewGroup, viewType: Int
    ): ViewHolder {
        return ViewHolder(
            LayoutInflater.from(mContext).inflate(R.layout.rik_reay_item, parent, false)
        )
    }

    override fun getItemCount(): Int {
        return rikReayModel.mainContent[2].table.size
    }

    override fun onBindViewHolder(holder: ViewHolder, position: Int) {
        val data = rikReayModel.mainContent[2].table[position]
        holder.leftItem.text = data.service
        holder.rightItem.text = data.charging
    }


}


