package com.seatel.mobilehall.ui.home.activity

import android.annotation.SuppressLint
import android.app.Activity
import android.content.Context
import android.content.Intent
import android.graphics.Bitmap
import android.net.Uri
import android.os.Bundle
import android.util.Log
import android.view.View
import android.webkit.WebResourceError
import android.webkit.WebResourceRequest
import android.webkit.WebView
import android.webkit.WebViewClient
import com.seatel.mobilehall.R
import com.seatel.mobilehall.databinding.ActivityWingPaymentBinding
import com.seatel.mobilehall.ui.base.activity.BaseActivity
import com.seatel.mobilehall.util.Constant
import com.seatel.mobilehall.util.SeatelAlertDialog
import com.seatel.mobilehall.util.customview.ErrorHandleView


class WingPaymentActivity : BaseActivity<ActivityWingPaymentBinding>() {
    private lateinit var mUrlPay: String
    private var mAmount: Double = 0.0
    private var mPhoneNumber: String? = null
    private var isAbleBack: Boolean = false
    private var isShowValentineDayPromotion = false

    private val mWebViewClient = object : WebViewClient() {

        override fun onPageStarted(view: WebView?, url: String?, favicon: Bitmap?) {
            super.onPageStarted(view, url, favicon)
            if (url != null && view != null) {
            }
        }

        override fun onPageFinished(view: WebView, url: String) {
            super.onPageFinished(view, url)
            showHideLoading(false)

        }

        override fun onReceivedError(
            view: WebView, request: WebResourceRequest, error: WebResourceError
        ) {
            super.onReceivedError(view, request, error)
            closeWingPaymentWithError()
        }

        override fun shouldOverrideUrlLoading(view: WebView?, url: String?): Boolean {
            Log.d("TAG::>>>", "shouldOverrideUrlLoading: $url ${Uri.parse(url).host} $view")

            val wingHostPro = "wingpay.wingbank.com.kh"
            val wingHostDev = "sdk-uat.wingmoney.com"
            val seatelHostPro = "yes.com.kh"
            val mSeatelHostPro = "www.yes.com.kh"
            val seatelHostDev = "dev.yes.com.kh"
            val seatelDeepLink = "api.yes.com.kh"

            if (url.toString().contains("status=success")) {
                TopUpSuccessActivity.lunch(
                    this@WingPaymentActivity,
                    Constant.TOPUP_SUCCESS,
                    mAmount.toString(),
                    mPhoneNumber!!,
                )
                return false
            }

            if (Uri.parse(url).host == seatelHostPro ||
                Uri.parse(url).host == mSeatelHostPro ||
                Uri.parse(url).host == wingHostPro ||
                Uri.parse(url).host == seatelDeepLink
            ) {
                return false
            }

            Intent(Intent.ACTION_VIEW, Uri.parse(url)).apply {
                startActivity(this)
                //  finish()
            }
            return true
        }


    }

    open fun isOverrideUrlLoading(view: WebView?, request: WebResourceRequest?): Boolean {
        return false
    }

    open fun isOverrideUrlLoading(view: WebView?, url: String?): Boolean {
        return false
    }

    private fun closeWingPaymentWithError() {

        showHideLoading(false)/* SeatelAlertDialog.with(this, getString(R.string.message_wing_error)).setCancelable(true)
             .setPositiveButton(getString(R.string.yes)) { _, _ ->
                 exitWingPayment(false)
             }.show()*/
    }

    private fun closePaymentProcress() {

        if (binding.webViewWing.canGoBack()) {
            binding.webViewWing.goBack()
        } else {
            showHideLoading(false)
            SeatelAlertDialog.with(this, getString(R.string.cancel_process_payment))
                .setCancelable(true).setPositiveButton(getString(R.string.yes)) { _, _ ->
                    exitWingPayment(false)
                }.setNegativeButton(getString(R.string.cancel)) { dailog, _ ->
                    dailog.dismiss()
                }.show()
        }
    }

    override fun isDisplayBackgroundBlur(): Boolean {
        return false
    }

    override fun isDisplayToolbar(): Boolean {
        return false
    }

    override fun isStatusBarColorDark(): Boolean {
        return true
    }


    private fun openDeeplink(url: String) {
        val intent = Intent(Intent.ACTION_VIEW)
        intent.data = Uri.parse(url)
        val packageManager = this.packageManager
        val resolvedActivities = packageManager.queryIntentActivities(intent, 0)
        if (resolvedActivities.size > 0) startActivity(intent)
        else gotoPlayStore()

    }


    private fun gotoPlayStore() {
        try {
            startActivity(
                Intent(
                    Intent.ACTION_VIEW, Uri.parse("market://details?id=com.wingmoney.wingpay")
                )
            )
        } catch (obj: android.content.ActivityNotFoundException) {
            startActivity(
                Intent(
                    Intent.ACTION_VIEW,
                    Uri.parse("https://play.google.com/store/apps/details?id=com.wingmoney.wingpay")
                )
            )
        }

    }

    override fun getViewBinding(): ActivityWingPaymentBinding {
        return ActivityWingPaymentBinding.inflate(layoutInflater)
    }

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
      //  setContentView(R.layout.activity_wing_payment)
        activityEnterFadeInAnimation()
        showHideLoading(true)
        init()
    }

    private fun showHideLoading(isShow: Boolean) {
        if (isShow) {
            binding.errorView.visibility = View.VISIBLE
            binding.errorView.setViewMode(ErrorHandleView.Mode.LOADING)
        } else {
            binding.errorView.visibility = View.GONE
        }
    }

    @SuppressLint("SetJavaScriptEnabled")
    private fun init() {
        isShowValentineDayPromotion = intent.getBooleanExtra("show_valentine_promotion", false)
        isAbleBack = intent.getBooleanExtra("is_able_back", false)
        mAmount = intent.getDoubleExtra("top_amount", 0.0)
        mPhoneNumber = intent.getStringExtra(Constant.PHONE_NUMBER)
        binding.webViewWing.isVerticalScrollBarEnabled = true
        binding.webViewWing!!.settings.javaScriptEnabled = true
        binding.webViewWing!!.webViewClient = mWebViewClient
        mUrlPay = intent.getStringExtra("payment_url").toString()
        Log.d("TAG::>>>", "wingUrl: $mUrlPay")
        binding.webViewWing!!.loadUrl(mUrlPay)
    }

    private fun onPageFinish(webView: WebView, url: String) {

        when {
            url.contains("result=success") -> {
                exitWingPayment(true)
            }

            url.contains("result=error") -> {
                exitWingPayment(false)
            }
        }
    }

    private fun exitWingPayment(isSuccess: Boolean) {
        showHideLoading(false)

        if (isSuccess) {
            val intent = Intent(this, PaymentActivity::class.java)
            intent.putExtra("show_valentine_promotion", isShowValentineDayPromotion)
            setResult(Activity.RESULT_OK, intent)
        }
        activityExitLeftAnimation()
        finish()

    }

    override fun onBackPressed() {
        super.onBackPressed()
        closePaymentProcress()
    }

    override fun onPause() {
        super.onPause()
        binding.webViewWing.onPause()
    }

    override fun onResume() {
        super.onResume()
        binding.webViewWing.onResume()
    }

    companion object {
        fun lunch(
            context: Context,
            url: String,
            amount: Double,
            isAbleBackPress: Boolean = false,
            ShowValentineDayPromotion: Boolean = false,
            phoneNumber: String
        ) {
            val i = Intent(context, WingPaymentActivity::class.java)
            i.putExtra("payment_url", url)
            i.putExtra("top_amount", amount)
            i.putExtra("is_able_back", isAbleBackPress)
            i.putExtra("show_valentine_promotion", ShowValentineDayPromotion)
            i.putExtra(Constant.PHONE_NUMBER, phoneNumber)
            (context as Activity).startActivityForResult(i, Constant.REQUEST_WING)
        }
    }
}
