package com.seatel.mobilehall.ui.home.presenter

import android.content.Context
import com.android.volley.Request
import com.google.gson.Gson
import com.seatel.mobilehall.data.network.SeatelJSONObjectRequest
import com.seatel.mobilehall.ui.home.interactor.TopUpWithPlanInteractor
import com.seatel.mobilehall.ui.home.model.TopUpWithPlanModel
import org.json.JSONObject

class TopUpWithPlanPresenter(var mContext: Context, var view: TopUpWithPlanInteractor.View) :
    TopUpWithPlanInteractor.Presenter {


    override fun onGetTopUpWithPlan(phoneNumber: String) {
        requestTopUpWithPlan(phoneNumber).setOnErrorListener {
            view.onGetTopUpWithPlanFailed(it)
        }.setOnResponseListener { response ->
            view.onGetTopUpWithPlanSucceed(getTopUpWithPlan(response as JSONObject))
        }.execute()
    }


    private fun getTopUpWithPlan(jsonObject: JSONObject): TopUpWithPlanModel {
        val gson = Gson()
        val data = gson.fromJson(jsonObject.toString(), TopUpWithPlanModel::class.java)
        return data
    }

    private fun requestTopUpWithPlan(phoneNumber: String): SeatelJSONObjectRequest {

        return object : SeatelJSONObjectRequest(mContext) {
            override fun getFunctionName(): String {
                return "top-up/amount-list?phoneNumber=$phoneNumber"
            }

            override fun getMethod(): Int {
                return Request.Method.GET
            }
        }


    }

}