package com.seatel.mobilehall.ui.yes_member.presenter

import android.content.Context
import com.android.volley.Request
import com.google.gson.Gson
import com.seatel.mobilehall.data.network.SeatelJSONObjectRequest
import com.seatel.mobilehall.ui.yes_member.interactor.SelectShopInteractor
import com.seatel.mobilehall.ui.yes_member.model.SelectShopModel
import org.json.JSONObject

class SelectShopPresenter(
    private var mContext: Context, private var rewardsDetailInteractor: SelectShopInteractor.View
) : SelectShopInteractor.Presenter {


    override fun getSelectShop(id: String, phoneNumber: String) {

        getSelectShopRequest(id, phoneNumber).setOnErrorListener {
            rewardsDetailInteractor.responseSelectShopFail(it)
        }.setOnResponseListener {
            rewardsDetailInteractor.responseSelectShopSucceed(getSelectShopList(it as JSONObject)!!)

        }.execute()
    }

    private fun getSelectShopList(response: JSONObject): SelectShopModel? {
        val data = Gson().fromJson(response.toString(), SelectShopModel::class.java)
        return data


    }

    private fun getSelectShopRequest(id: String, phoneNumber: String): SeatelJSONObjectRequest {

        return object : SeatelJSONObjectRequest(mContext) {

            override fun getFunctionName(): String {
                return "yes-member/reward/$id?phoneNumber=$phoneNumber"
            }

            override fun getMethod(): Int {
                return Request.Method.GET
            }


        }


    }


}