package com.seatel.mobilehall.util.customview

import android.content.Context
import android.graphics.*
import android.util.AttributeSet
import android.view.View
import com.seatel.mobilehall.R

class StrokedTextView @JvmOverloads constructor(
    context: Context,
    attrs: AttributeSet? = null,
    defStyleAttr: Int = 0
) : View(context, attrs, defStyleAttr) {

    var text: String = "Hello, World!" // Default text
    private val textSize = 60f
    private val strokeWidth = 10f
    private val textColor = Color.WHITE
    private val strokeColor = context.getColor(R.color.colorPrimary)

    private val textPaint = Paint().apply {
        isAntiAlias = true
        textSize = this@StrokedTextView.textSize
        color = textColor
        style = Paint.Style.FILL
    }

    private val strokePaint = Paint().apply {
        isAntiAlias = true
        textSize = this@StrokedTextView.textSize
        color = strokeColor
        style = Paint.Style.STROKE
        strokeWidth = this@StrokedTextView.strokeWidth
    }

    init {
        // Load custom attributes
        attrs?.let {
            val typedArray = context.obtainStyledAttributes(it, R.styleable.StrokedTextView, 0, 0)
            text = typedArray.getString(R.styleable.StrokedTextView_text) ?: "Hello, World!"
            typedArray.recycle()
        }
    }

    override fun onDraw(canvas: Canvas) {
        super.onDraw(canvas)

        // Calculate text position (centered)
        val x = (width - textPaint.measureText(text)) / 2
        val y = (height + textSize) / 2

        // Draw the stroke first
        canvas.drawText(text, x, y, strokePaint)

        // Draw the text on top
        canvas.drawText(text, x, y, textPaint)
    }
}