package com.seatel.mobilehall.ui.home.adapter

import android.content.Context
import android.view.LayoutInflater
import android.view.ViewGroup
import androidx.recyclerview.widget.RecyclerView
import com.seatel.mobilehall.R
import com.seatel.mobilehall.ui.home.viewholder.CartDeviceViewHolder
import com.seatel.mobilehall.ui.home.viewholder.CartScratchViewHolder
import com.seatel.mobilehall.ui.home.viewholder.CartSimViewHolder
import com.seatel.mobilehall.util.manager.OrderingManager
import com.seatel.mobilehall.databinding.HolderCartDeviceItemBinding
import com.seatel.mobilehall.databinding.HolderCartSimItemBinding
import com.seatel.mobilehall.databinding.HolderCartScratchItemBinding

class OrderSummaryAdapter(context: Context?) : MyCartAdapter(context, null, null, null) {

    override fun onGetData() {
        // You can override this if needed to get data for the order summary.
    }

    override fun getItemViewType(position: Int): Int {
        return when (OrderingManager.getInstance().selectedCartsModels[position].type) {
            "device" -> DEVICE
            "sim-card" -> SIM
            else -> SCRATCH
        }
    }

    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): RecyclerView.ViewHolder {
        return when (viewType) {
            DEVICE -> CartDeviceViewHolder(
                HolderCartDeviceItemBinding.inflate(LayoutInflater.from(context), parent, false)
            )
            SIM -> CartSimViewHolder(
                HolderCartSimItemBinding.inflate(LayoutInflater.from(context), parent, false)
            )
            else -> CartScratchViewHolder(
                HolderCartScratchItemBinding.inflate(LayoutInflater.from(context), parent, false)
            )
        }
    }

    override fun getItemCount(): Int {
        return OrderingManager.getInstance().selectedCartsModels.size
    }

    override fun onBindViewHolder(holder: RecyclerView.ViewHolder, position: Int) {
        when (holder) {
            is CartDeviceViewHolder -> holder.onBind(OrderingManager.getInstance().selectedCartsModels[position])
            is CartScratchViewHolder -> holder.onBind(OrderingManager.getInstance().selectedCartsModels[position])
            is CartSimViewHolder -> holder.onBind(OrderingManager.getInstance().selectedCartsModels[position])
        }
    }

    companion object {
        const val DEVICE = 0
        const val SIM = 1
        const val SCRATCH = 2
    }
}
