package com.seatel.mobilehall.ui.yes_member.activity

import android.content.Context
import android.content.Intent
import android.os.Bundle
import com.android.volley.VolleyError
import com.seatel.mobilehall.data.network.SeatelSuperRequest
import com.seatel.mobilehall.databinding.ActivityRewardHistoryBinding
import com.seatel.mobilehall.ui.base.activity.BaseActivity
import com.seatel.mobilehall.ui.yes_member.adapter.RewardHistoryAdapter
import com.seatel.mobilehall.ui.yes_member.interactor.RewardHistoryInteractor
import com.seatel.mobilehall.ui.yes_member.model.RewardHistoryModel
import com.seatel.mobilehall.ui.yes_member.presenter.RewardHistoryPresenter
import com.seatel.mobilehall.util.SeatelAlertDialog

class RewardHistoryActivity : BaseActivity<ActivityRewardHistoryBinding>(),
    RewardHistoryInteractor.View {

    companion object {
        fun launch(context: Context) {
            val intent = Intent(context, RewardHistoryActivity::class.java)
            context.startActivity(intent)
        }

    }

    override fun getViewBinding(): ActivityRewardHistoryBinding {
        return ActivityRewardHistoryBinding.inflate(layoutInflater)
    }


    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        super.activityEnterRightAnimation()
        RewardHistoryPresenter(this, this).getRewardHistory(getPhoneLogin())

    }

    override fun responseRewardHistorySucceed(rewardHistoryList: RewardHistoryModel) {
        binding.recyclerRewardHistory.adapter = RewardHistoryAdapter(this, rewardHistoryList.data)
    }

    override fun responseRewardHistoryFail(error: VolleyError) {
        SeatelAlertDialog.with(this, SeatelSuperRequest.getErrorMessageFrom(error))
            .show()
    }

    override fun getStringToolbarTitle(): String? {
        return "Redeemed Reward History"
    }

    override fun onBackPressed() {
        super.onBackPressed()
        super.activityExitLeftAnimation()
    }
}